/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.context;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import info.archinnov.achilles.exception.AchillesStaleObjectStateException;
import info.archinnov.achilles.interceptor.Event;
import info.archinnov.achilles.internal.consistency.ConsistencyOverrider;
import info.archinnov.achilles.internal.context.AbstractFlushContext;
import info.archinnov.achilles.internal.context.ConfigurationContext;
import info.archinnov.achilles.internal.context.DaoContext;
import info.archinnov.achilles.internal.context.facade.DaoOperations;
import info.archinnov.achilles.internal.context.facade.EntityOperations;
import info.archinnov.achilles.internal.context.facade.PersistenceManagerOperations;
import info.archinnov.achilles.internal.context.facade.PersistentStateHolder;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.persistence.operations.EntityInitializer;
import info.archinnov.achilles.internal.persistence.operations.EntityLoader;
import info.archinnov.achilles.internal.persistence.operations.EntityPersister;
import info.archinnov.achilles.internal.persistence.operations.EntityProxifier;
import info.archinnov.achilles.internal.persistence.operations.EntityRefresher;
import info.archinnov.achilles.internal.persistence.operations.EntityUpdater;
import info.archinnov.achilles.internal.proxy.dirtycheck.DirtyCheckChangeSet;
import info.archinnov.achilles.internal.statement.wrapper.AbstractStatementWrapper;
import info.archinnov.achilles.internal.validation.Validator;
import info.archinnov.achilles.type.Options;
import info.archinnov.achilles.type.OptionsBuilder;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceContext {
    private static final Logger log = LoggerFactory.getLogger(PersistenceContext.class);
    protected AbstractFlushContext flushContext;
    protected EntityInitializer initializer = new EntityInitializer();
    protected EntityPersister persister = new EntityPersister();
    protected EntityProxifier proxifier = new EntityProxifier();
    protected EntityRefresher refresher = new EntityRefresher();
    protected EntityLoader loader = new EntityLoader();
    protected EntityUpdater updater = new EntityUpdater();
    protected ConfigurationContext configContext;
    protected Class<?> entityClass;
    protected EntityMeta entityMeta;
    protected Object entity;
    protected Object primaryKey;
    protected Object partitionKey;
    protected Options options = OptionsBuilder.noOptions();
    protected DaoContext daoContext;
    private ConsistencyOverrider overrider = new ConsistencyOverrider();
    protected PersistenceManagerFacade persistenceManagerFacade = new PersistenceManagerFacade();
    protected EntityFacade entityFacade = new EntityFacade();
    protected DaoFacade daoFacade = new DaoFacade();
    protected StateHolderFacade stateHolderFacade = new StateHolderFacade();
    private Function<PropertyMeta, Method> metaToGetter = new Function<PropertyMeta, Method>(){

        public Method apply(PropertyMeta meta) {
            return meta.getGetter();
        }
    };

    public PersistenceContext(EntityMeta entityMeta, ConfigurationContext configContext, DaoContext daoContext, AbstractFlushContext flushContext, Class<?> entityClass, Object primaryKey, Options options) {
        Validator.validateNotNull(entityClass, "The entity class should not be null for persistence context creation", new Object[0]);
        Validator.validateNotNull(primaryKey, "The primary key for the entity class '{}' should not be null for persistence context creation", entityClass.getCanonicalName());
        this.entityMeta = entityMeta;
        this.configContext = configContext;
        this.daoContext = daoContext;
        this.flushContext = flushContext;
        this.entityClass = entityClass;
        this.primaryKey = primaryKey;
        this.options = this.overrider.overrideRuntimeValueByBatchSetting(options, flushContext);
    }

    public PersistenceContext(EntityMeta entityMeta, ConfigurationContext configContext, DaoContext daoContext, AbstractFlushContext flushContext, Object entity, Options options) {
        Validator.validateNotNull(entity, "The entity of type '{}' should not be null for persistence context creation", entityMeta.getClassName());
        this.primaryKey = entityMeta.getPrimaryKey(entity);
        Validator.validateNotNull(this.primaryKey, "The primary key for the entity class '{}' should not be null for persistence context creation", entityMeta.getClassName());
        this.entityClass = entityMeta.getEntityClass();
        this.entityMeta = entityMeta;
        this.configContext = configContext;
        this.daoContext = daoContext;
        this.flushContext = flushContext;
        this.entity = entity;
        this.options = this.overrider.overrideRuntimeValueByBatchSetting(options, flushContext);
    }

    public PersistenceContext duplicate(Object entity) {
        log.trace("Duplicate PersistenceContext for entity '{}'", entity);
        return new PersistenceContext(this.entityMeta, this.configContext, this.daoContext, this.flushContext.duplicate(), entity, this.options.duplicateWithoutTtlAndTimestamp());
    }

    public StateHolderFacade getStateHolderFacade() {
        return this.stateHolderFacade;
    }

    public EntityFacade getEntityFacade() {
        return this.entityFacade;
    }

    public PersistenceManagerFacade getPersistenceManagerFacade() {
        return this.persistenceManagerFacade;
    }

    public String toString() {
        return Objects.toStringHelper(PersistenceContext.class).add("entity class", this.entityClass).add("primary key", this.primaryKey).add("partition key", this.partitionKey).toString();
    }

    public class DaoFacade
    extends StateHolderFacade
    implements DaoOperations {
        private DaoFacade() {
        }

        @Override
        public void pushStatement(AbstractStatementWrapper statementWrapper) {
            PersistenceContext.this.flushContext.pushStatement(statementWrapper);
        }

        @Override
        public void pushCounterStatement(AbstractStatementWrapper statementWrapper) {
            PersistenceContext.this.flushContext.pushCounterStatement(statementWrapper);
        }

        @Override
        public ResultSet executeImmediate(AbstractStatementWrapper bsWrapper) {
            return PersistenceContext.this.flushContext.executeImmediate(bsWrapper);
        }
    }

    public class EntityFacade
    extends StateHolderFacade
    implements EntityOperations {
        private EntityFacade() {
        }

        @Override
        public Row loadEntity() {
            return PersistenceContext.this.daoContext.loadEntity(PersistenceContext.this.daoFacade);
        }

        @Override
        public Row loadProperty(PropertyMeta pm) {
            return PersistenceContext.this.daoContext.loadProperty(PersistenceContext.this.daoFacade, pm);
        }

        @Override
        public void pushInsertStatement() {
            List<PropertyMeta> pms = PersistenceContext.this.entityMeta.retrievePropertyMetasForInsert(PersistenceContext.this.entity);
            PersistenceContext.this.daoContext.pushInsertStatement(PersistenceContext.this.daoFacade, pms);
        }

        @Override
        public void pushUpdateStatement(List<PropertyMeta> pms) {
            PersistenceContext.this.daoContext.pushUpdateStatement(PersistenceContext.this.daoFacade, pms);
        }

        @Override
        public void pushCollectionAndMapUpdateStatements(DirtyCheckChangeSet changeSet) {
            PersistenceContext.this.daoContext.pushCollectionAndMapUpdateStatement(PersistenceContext.this.daoFacade, changeSet);
        }

        @Override
        public void bindForRemoval(String tableName) {
            PersistenceContext.this.daoContext.bindForRemoval(PersistenceContext.this.daoFacade, PersistenceContext.this.entityMeta, tableName);
        }

        @Override
        public void bindForSimpleCounterIncrement(PropertyMeta counterMeta, Long increment) {
            PersistenceContext.this.daoContext.bindForSimpleCounterIncrement(PersistenceContext.this.daoFacade, counterMeta, increment);
        }

        @Override
        public Long getSimpleCounter(PropertyMeta counterMeta, info.archinnov.achilles.type.ConsistencyLevel consistency) {
            log.trace("Get counter value for counterMeta '{}' with consistency level '{}'", (Object)counterMeta, (Object)consistency);
            Row row = PersistenceContext.this.daoContext.getSimpleCounter(PersistenceContext.this.daoFacade, counterMeta, consistency);
            if (row != null) {
                return row.getLong("counter_value");
            }
            return null;
        }

        @Override
        public void bindForSimpleCounterRemoval(PropertyMeta counterMeta) {
            PersistenceContext.this.daoContext.bindForSimpleCounterDelete(PersistenceContext.this.daoFacade, counterMeta);
        }

        @Override
        public void pushClusteredCounterIncrementStatement(PropertyMeta counterMeta, Long increment) {
            PersistenceContext.this.daoContext.pushClusteredCounterIncrementStatement(PersistenceContext.this.daoFacade, counterMeta, increment);
        }

        @Override
        public Row getClusteredCounter() {
            log.trace("Get clustered counter value for entityMeta '{}'", (Object)PersistenceContext.this.entityMeta);
            return PersistenceContext.this.daoContext.getClusteredCounter(PersistenceContext.this.daoFacade);
        }

        @Override
        public Long getClusteredCounterColumn(PropertyMeta counterMeta) {
            log.trace("Get clustered counter value for counterMeta '{}'", (Object)counterMeta);
            return PersistenceContext.this.daoContext.getClusteredCounterColumn(PersistenceContext.this.daoFacade, counterMeta);
        }

        @Override
        public void bindForClusteredCounterRemoval() {
            PersistenceContext.this.daoContext.bindForClusteredCounterDelete(PersistenceContext.this.daoFacade);
        }
    }

    public class PersistenceManagerFacade
    extends StateHolderFacade
    implements PersistenceManagerOperations {
        private PersistenceManagerFacade() {
        }

        @Override
        public <T> T persist(T rawEntity) {
            PersistenceContext.this.flushContext.triggerInterceptor(PersistenceContext.this.entityMeta, rawEntity, Event.PRE_PERSIST);
            PersistenceContext.this.persister.persist(PersistenceContext.this.entityFacade);
            this.flush();
            PersistenceContext.this.flushContext.triggerInterceptor(PersistenceContext.this.entityMeta, rawEntity, Event.POST_PERSIST);
            return PersistenceContext.this.proxifier.buildProxyWithAllFieldsLoadedExceptCounters(rawEntity, PersistenceContext.this.entityFacade);
        }

        @Override
        public void update(Object proxifiedEntity) {
            PersistenceContext.this.flushContext.triggerInterceptor(PersistenceContext.this.entityMeta, PersistenceContext.this.entity, Event.PRE_UPDATE);
            PersistenceContext.this.updater.update(PersistenceContext.this.entityFacade, proxifiedEntity);
            this.flush();
            PersistenceContext.this.flushContext.triggerInterceptor(PersistenceContext.this.entityMeta, PersistenceContext.this.entity, Event.POST_UPDATE);
        }

        @Override
        public void remove() {
            PersistenceContext.this.flushContext.triggerInterceptor(PersistenceContext.this.entityMeta, PersistenceContext.this.entity, Event.PRE_REMOVE);
            PersistenceContext.this.persister.remove(PersistenceContext.this.entityFacade);
            this.flush();
            PersistenceContext.this.flushContext.triggerInterceptor(PersistenceContext.this.entityMeta, PersistenceContext.this.entity, Event.POST_REMOVE);
        }

        @Override
        public <T> T find(Class<T> entityClass) {
            T rawEntity = PersistenceContext.this.loader.load(PersistenceContext.this.entityFacade, entityClass);
            T proxifiedEntity = null;
            if (rawEntity != null) {
                PersistenceContext.this.flushContext.triggerInterceptor(PersistenceContext.this.entityMeta, rawEntity, Event.POST_LOAD);
                proxifiedEntity = PersistenceContext.this.proxifier.buildProxyWithAllFieldsLoadedExceptCounters(rawEntity, PersistenceContext.this.entityFacade);
            }
            return proxifiedEntity;
        }

        @Override
        public <T> T getProxy(Class<T> entityClass) {
            T entity = PersistenceContext.this.loader.createEmptyEntity(PersistenceContext.this.entityFacade, entityClass);
            return PersistenceContext.this.proxifier.buildProxyWithNoFieldLoaded(entity, PersistenceContext.this.entityFacade);
        }

        @Override
        public void refresh(Object proxifiedEntity) throws AchillesStaleObjectStateException {
            PersistenceContext.this.refresher.refresh(proxifiedEntity, PersistenceContext.this.entityFacade);
            PersistenceContext.this.flushContext.triggerInterceptor(PersistenceContext.this.entityMeta, PersistenceContext.this.entity, Event.POST_LOAD);
        }

        @Override
        public <T> T initialize(T proxifiedEntity) {
            PersistenceContext.this.initializer.initializeEntity(proxifiedEntity, PersistenceContext.this.entityMeta);
            return proxifiedEntity;
        }

        @Override
        public <T> List<T> initialize(List<T> entities) {
            for (T entity : entities) {
                this.initialize(entity);
            }
            return entities;
        }

        @Override
        public <T> Set<T> initialize(Set<T> entities) {
            for (T entity : entities) {
                this.initialize(entity);
            }
            return entities;
        }

        protected void flush() {
            PersistenceContext.this.flushContext.flush();
        }
    }

    public class StateHolderFacade
    implements PersistentStateHolder {
        private StateHolderFacade() {
        }

        @Override
        public PropertyMeta getIdMeta() {
            return PersistenceContext.this.entityMeta.getIdMeta();
        }

        @Override
        public boolean isClusteredCounter() {
            return PersistenceContext.this.entityMeta.isClusteredCounter();
        }

        @Override
        public EntityMeta getEntityMeta() {
            return PersistenceContext.this.entityMeta;
        }

        @Override
        public Object getEntity() {
            return PersistenceContext.this.entity;
        }

        @Override
        public void setEntity(Object entity) {
            PersistenceContext.this.entity = entity;
        }

        @Override
        public <T> Class<T> getEntityClass() {
            return PersistenceContext.this.entityClass;
        }

        @Override
        public Object getPrimaryKey() {
            return PersistenceContext.this.primaryKey;
        }

        @Override
        public Options getOptions() {
            return PersistenceContext.this.options;
        }

        @Override
        public Optional<Integer> getTtl() {
            return PersistenceContext.this.options.getTtl();
        }

        @Override
        public Optional<Long> getTimestamp() {
            return PersistenceContext.this.options.getTimestamp();
        }

        @Override
        public Optional<info.archinnov.achilles.type.ConsistencyLevel> getConsistencyLevel() {
            return PersistenceContext.this.options.getConsistencyLevel();
        }

        @Override
        public Optional<ConsistencyLevel> getSerialConsistencyLevel() {
            return PersistenceContext.this.options.getSerialConsistency();
        }

        @Override
        public List<Options.CASCondition> getCasConditions() {
            return (List)Optional.fromNullable(PersistenceContext.this.options.getCASConditions()).or(new ArrayList());
        }

        @Override
        public boolean hasCasConditions() {
            return PersistenceContext.this.options.hasCasConditions();
        }

        @Override
        public Optional getCASResultListener() {
            return PersistenceContext.this.options.getCasResultListener();
        }

        @Override
        public Set<Method> getAllGettersExceptCounters() {
            return new HashSet<Method>((Collection<Method>)FluentIterable.from(PersistenceContext.this.entityMeta.getAllMetasExceptCounters()).transform(PersistenceContext.this.metaToGetter).toList());
        }

        @Override
        public List<PropertyMeta> getAllCountersMeta() {
            return PersistenceContext.this.entityMeta.getAllCounterMetas();
        }

        @Override
        public ConfigurationContext getConfigContext() {
            return PersistenceContext.this.configContext;
        }
    }
}

