/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.context;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.ConsistencyLevel;
import com.google.common.base.Optional;
import info.archinnov.achilles.interceptor.Event;
import info.archinnov.achilles.internal.context.AbstractFlushContext;
import info.archinnov.achilles.internal.context.DaoContext;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.statement.wrapper.AbstractStatementWrapper;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmediateFlushContext
extends AbstractFlushContext {
    private static final Logger log = LoggerFactory.getLogger(ImmediateFlushContext.class);

    public ImmediateFlushContext(DaoContext daoContext, info.archinnov.achilles.type.ConsistencyLevel consistencyLevel, Optional<ConsistencyLevel> serialConsistencyLevel) {
        super(daoContext, consistencyLevel, serialConsistencyLevel);
    }

    private ImmediateFlushContext(DaoContext daoContext, List<AbstractStatementWrapper> statementWrappers, info.archinnov.achilles.type.ConsistencyLevel consistencyLevel, Optional<ConsistencyLevel> serialConsistencyLevel) {
        super(daoContext, statementWrappers, consistencyLevel, serialConsistencyLevel);
    }

    @Override
    public void startBatch() {
        throw new UnsupportedOperationException("Cannot start a batch with a normal PersistenceManager. Please create a BatchingPersistenceManager instead");
    }

    @Override
    public void endBatch() {
        throw new UnsupportedOperationException("Cannot end a batch with a normal PersistenceManager. Please create a BatchingPersistenceManager instead");
    }

    @Override
    public void flush() {
        log.debug("Flush immediately all pending statements");
        this.executeBatch(BatchStatement.Type.UNLOGGED, this.statementWrappers);
        this.executeBatch(BatchStatement.Type.COUNTER, this.counterStatementWrappers);
    }

    @Override
    public AbstractFlushContext.FlushType type() {
        return AbstractFlushContext.FlushType.IMMEDIATE;
    }

    @Override
    public ImmediateFlushContext duplicate() {
        log.trace("Duplicate immediate flushing context");
        return new ImmediateFlushContext(this.daoContext, this.statementWrappers, this.consistencyLevel, (Optional<ConsistencyLevel>)this.serialConsistencyLevel);
    }

    @Override
    public void triggerInterceptor(EntityMeta meta, Object entity, Event event) {
        meta.intercept(entity, event);
    }
}

