/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.context;

import com.fasterxml.jackson.databind.ObjectMapper;
import info.archinnov.achilles.internal.interceptor.DefaultBeanValidationInterceptor;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.json.ObjectMapperFactory;
import info.archinnov.achilles.type.ConsistencyLevel;
import info.archinnov.achilles.type.InsertStrategy;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Validator;

public class ConfigurationContext {
    private boolean forceColumnFamilyCreation;
    private boolean enableSchemaUpdate;
    private Map<String, Boolean> enableSchemaUpdateForTables;
    private ObjectMapperFactory objectMapperFactory;
    private ConsistencyLevel defaultReadConsistencyLevel;
    private ConsistencyLevel defaultWriteConsistencyLevel;
    private Map<String, ConsistencyLevel> readConsistencyLevelMap = new HashMap<String, ConsistencyLevel>();
    private Map<String, ConsistencyLevel> writeConsistencyLevelMap = new HashMap<String, ConsistencyLevel>();
    private Validator beanValidator;
    private DefaultBeanValidationInterceptor beanValidationInterceptor;
    private int preparedStatementLRUCacheSize = 10000;
    private InsertStrategy insertStrategy;
    private ClassLoader OSGIClassLoader;

    public boolean isForceColumnFamilyCreation() {
        return this.forceColumnFamilyCreation;
    }

    public void setForceColumnFamilyCreation(boolean forceColumnFamilyCreation) {
        this.forceColumnFamilyCreation = forceColumnFamilyCreation;
    }

    public boolean isEnableSchemaUpdate() {
        return this.enableSchemaUpdate;
    }

    public void setEnableSchemaUpdateForTables(Map<String, Boolean> enableSchemaUpdateForTables) {
        this.enableSchemaUpdateForTables = enableSchemaUpdateForTables;
    }

    public Map<String, Boolean> getEnableSchemaUpdateForTables() {
        return this.enableSchemaUpdateForTables;
    }

    public void setEnableSchemaUpdate(boolean enableSchemaUpdate) {
        this.enableSchemaUpdate = enableSchemaUpdate;
    }

    public ObjectMapperFactory getObjectMapperFactory() {
        return this.objectMapperFactory;
    }

    public void setObjectMapperFactory(ObjectMapperFactory objectMapperFactory) {
        this.objectMapperFactory = objectMapperFactory;
    }

    public ConsistencyLevel getDefaultReadConsistencyLevel() {
        return this.defaultReadConsistencyLevel;
    }

    public void setDefaultReadConsistencyLevel(ConsistencyLevel defaultReadConsistencyLevel) {
        this.defaultReadConsistencyLevel = defaultReadConsistencyLevel;
    }

    public ConsistencyLevel getDefaultWriteConsistencyLevel() {
        return this.defaultWriteConsistencyLevel;
    }

    public void setDefaultWriteConsistencyLevel(ConsistencyLevel defaultWriteConsistencyLevel) {
        this.defaultWriteConsistencyLevel = defaultWriteConsistencyLevel;
    }

    public Validator getBeanValidator() {
        return this.beanValidator;
    }

    public void setBeanValidator(Validator beanValidator) {
        this.beanValidator = beanValidator;
    }

    public int getPreparedStatementLRUCacheSize() {
        return this.preparedStatementLRUCacheSize;
    }

    public void setPreparedStatementLRUCacheSize(int preparedStatementLRUCacheSize) {
        this.preparedStatementLRUCacheSize = preparedStatementLRUCacheSize;
    }

    public InsertStrategy getInsertStrategy() {
        return this.insertStrategy;
    }

    public void setInsertStrategy(InsertStrategy insertStrategy) {
        this.insertStrategy = insertStrategy;
    }

    public void setOSGIClassLoader(ClassLoader OSGIClassLoader) {
        this.OSGIClassLoader = OSGIClassLoader;
    }

    public boolean isClassConstrained(Class<?> clazz) {
        if (this.beanValidator != null) {
            return this.beanValidator.getConstraintsForClass(clazz).isBeanConstrained();
        }
        return false;
    }

    public void addBeanValidationInterceptor(EntityMeta meta) {
        if (this.beanValidationInterceptor == null) {
            this.beanValidationInterceptor = new DefaultBeanValidationInterceptor(this.beanValidator);
        }
        meta.addInterceptor(this.beanValidationInterceptor);
    }

    public ConsistencyLevel getReadConsistencyLevelForTable(String tableName) {
        return this.readConsistencyLevelMap.get(tableName);
    }

    public ConsistencyLevel getWriteConsistencyLevelForTable(String tableName) {
        return this.writeConsistencyLevelMap.get(tableName);
    }

    public ObjectMapper getMapperFor(Class<?> type) {
        return this.objectMapperFactory.getMapper(type);
    }

    public ClassLoader selectClassLoader(Class<?> entityClass) {
        return this.OSGIClassLoader != null ? this.OSGIClassLoader : entityClass.getClassLoader();
    }

    public ClassLoader selectClassLoader() {
        return this.OSGIClassLoader != null ? this.OSGIClassLoader : this.getClass().getClassLoader();
    }

    public void setReadConsistencyLevelMap(Map<String, ConsistencyLevel> readConsistencyLevelMap) {
        this.readConsistencyLevelMap = readConsistencyLevelMap;
    }

    public void setWriteConsistencyLevelMap(Map<String, ConsistencyLevel> writeConsistencyLevelMap) {
        this.writeConsistencyLevelMap = writeConsistencyLevelMap;
    }
}

