/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.context;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.ConsistencyLevel;
import com.google.common.base.Optional;
import info.archinnov.achilles.interceptor.Event;
import info.archinnov.achilles.internal.context.AbstractFlushContext;
import info.archinnov.achilles.internal.context.DaoContext;
import info.archinnov.achilles.internal.interceptor.EventHolder;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.statement.wrapper.AbstractStatementWrapper;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchingFlushContext
extends AbstractFlushContext {
    private static final Logger log = LoggerFactory.getLogger(BatchingFlushContext.class);
    protected List<EventHolder> eventHolders = new ArrayList<EventHolder>();

    public BatchingFlushContext(DaoContext daoContext, info.archinnov.achilles.type.ConsistencyLevel consistencyLevel, Optional<ConsistencyLevel> serialConsistencyLevel) {
        super(daoContext, consistencyLevel, serialConsistencyLevel);
    }

    private BatchingFlushContext(DaoContext daoContext, List<AbstractStatementWrapper> statementWrappers, info.archinnov.achilles.type.ConsistencyLevel consistencyLevel, Optional<ConsistencyLevel> serialConsistencyLevel) {
        super(daoContext, statementWrappers, consistencyLevel, serialConsistencyLevel);
    }

    @Override
    public void startBatch() {
        log.debug("Starting a new batch");
    }

    @Override
    public void flush() {
        log.debug("Flush called but do nothing. Flushing is done only at the end of the batch");
    }

    @Override
    public void endBatch() {
        log.debug("Ending current batch");
        for (EventHolder eventHolder : this.eventHolders) {
            eventHolder.triggerInterception();
        }
        this.executeBatch(BatchStatement.Type.LOGGED, this.statementWrappers);
        this.executeBatch(BatchStatement.Type.COUNTER, this.counterStatementWrappers);
    }

    @Override
    public AbstractFlushContext.FlushType type() {
        return AbstractFlushContext.FlushType.BATCH;
    }

    @Override
    public BatchingFlushContext duplicate() {
        return new BatchingFlushContext(this.daoContext, this.statementWrappers, this.consistencyLevel, (Optional<ConsistencyLevel>)this.serialConsistencyLevel);
    }

    @Override
    public void triggerInterceptor(EntityMeta meta, Object entity, Event event) {
        if (event == Event.POST_LOAD) {
            meta.intercept(entity, Event.POST_LOAD);
        } else {
            this.eventHolders.add(new EventHolder(meta, entity, event));
        }
    }

    public BatchingFlushContext duplicateWithNoData(info.archinnov.achilles.type.ConsistencyLevel defaultConsistencyLevel) {
        return new BatchingFlushContext(this.daoContext, new ArrayList<AbstractStatementWrapper>(), defaultConsistencyLevel, (Optional<ConsistencyLevel>)this.serialConsistencyLevel);
    }

    public BatchingFlushContext duplicateWithNoData(info.archinnov.achilles.type.ConsistencyLevel defaultConsistencyLevel, Optional<ConsistencyLevel> serialConsistencyLevel) {
        return new BatchingFlushContext(this.daoContext, new ArrayList<AbstractStatementWrapper>(), defaultConsistencyLevel, serialConsistencyLevel);
    }

    public BatchingFlushContext duplicateWithNoData() {
        return new BatchingFlushContext(this.daoContext, new ArrayList<AbstractStatementWrapper>(), this.consistencyLevel, (Optional<ConsistencyLevel>)this.serialConsistencyLevel);
    }
}

