/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.context;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.ResultSet;
import com.google.common.base.Optional;
import info.archinnov.achilles.interceptor.Event;
import info.archinnov.achilles.internal.consistency.ConsistencyConverter;
import info.archinnov.achilles.internal.context.DaoContext;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.statement.wrapper.AbstractStatementWrapper;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractFlushContext {
    protected DaoContext daoContext;
    protected List<AbstractStatementWrapper> statementWrappers = new ArrayList<AbstractStatementWrapper>();
    protected List<AbstractStatementWrapper> counterStatementWrappers = new ArrayList<AbstractStatementWrapper>();
    protected info.archinnov.achilles.type.ConsistencyLevel consistencyLevel;
    protected Optional<ConsistencyLevel> serialConsistencyLevel = Optional.absent();

    public AbstractFlushContext(DaoContext daoContext, info.archinnov.achilles.type.ConsistencyLevel consistencyLevel, Optional<ConsistencyLevel> serialConsistencyLevel) {
        this.daoContext = daoContext;
        this.consistencyLevel = consistencyLevel;
        this.serialConsistencyLevel = serialConsistencyLevel;
    }

    protected AbstractFlushContext(DaoContext daoContext, List<AbstractStatementWrapper> statementWrappers, info.archinnov.achilles.type.ConsistencyLevel consistencyLevel, Optional<ConsistencyLevel> serialConsistencyLevel) {
        this.statementWrappers = statementWrappers;
        this.daoContext = daoContext;
        this.consistencyLevel = consistencyLevel;
        this.serialConsistencyLevel = serialConsistencyLevel;
    }

    protected void executeBatch(BatchStatement.Type batchType, List<AbstractStatementWrapper> statementWrappers) {
        if (statementWrappers.size() > 1) {
            BatchStatement batch = new BatchStatement(batchType);
            AbstractStatementWrapper.writeDMLStartBatch(batchType);
            for (AbstractStatementWrapper statementWrapper : statementWrappers) {
                batch.add(statementWrapper.getStatement());
                statementWrapper.logDMLStatement("\t");
            }
            AbstractStatementWrapper.writeDMLEndBatch(batchType, this.consistencyLevel);
            if (this.consistencyLevel != null) {
                batch.setConsistencyLevel(ConsistencyConverter.getCQLLevel(this.consistencyLevel));
            }
            if (this.serialConsistencyLevel.isPresent()) {
                batch.setSerialConsistencyLevel((ConsistencyLevel)this.serialConsistencyLevel.get());
            }
            this.daoContext.executeBatch(batch);
        } else if (statementWrappers.size() == 1) {
            this.daoContext.execute(statementWrappers.get(0));
        }
    }

    public void pushStatement(AbstractStatementWrapper statementWrapper) {
        this.statementWrappers.add(statementWrapper);
    }

    public void pushCounterStatement(AbstractStatementWrapper statementWrapper) {
        this.counterStatementWrappers.add(statementWrapper);
    }

    public ResultSet executeImmediate(AbstractStatementWrapper statementWrapper) {
        return this.daoContext.execute(statementWrapper);
    }

    public info.archinnov.achilles.type.ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public abstract void startBatch();

    public abstract void flush();

    public abstract void endBatch();

    public abstract FlushType type();

    public abstract AbstractFlushContext duplicate();

    public abstract void triggerInterceptor(EntityMeta var1, Object var2, Event var3);

    public String toString() {
        return this.type().toString();
    }

    public static enum FlushType {
        BATCH,
        IMMEDIATE;

    }
}

