/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.consistency;

import info.archinnov.achilles.internal.context.AbstractFlushContext;
import info.archinnov.achilles.internal.context.facade.PersistentStateHolder;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.type.ConsistencyLevel;
import info.archinnov.achilles.type.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistencyOverrider {
    private static final Logger log = LoggerFactory.getLogger(ConsistencyOverrider.class);

    public Options overrideRuntimeValueByBatchSetting(Options options, AbstractFlushContext flushContext) {
        Options result = options;
        if (flushContext.type() == AbstractFlushContext.FlushType.BATCH && flushContext.getConsistencyLevel() != null) {
            result = options.duplicateWithNewConsistencyLevel(flushContext.getConsistencyLevel());
        }
        return result;
    }

    public ConsistencyLevel getReadLevel(PersistentStateHolder context) {
        EntityMeta entityMeta = context.getEntityMeta();
        ConsistencyLevel readLevel = context.getConsistencyLevel().isPresent() ? (ConsistencyLevel)context.getConsistencyLevel().get() : entityMeta.getReadConsistencyLevel();
        log.trace("Read consistency level : " + readLevel);
        return readLevel;
    }

    public ConsistencyLevel getWriteLevel(PersistentStateHolder context) {
        EntityMeta entityMeta = context.getEntityMeta();
        ConsistencyLevel writeLevel = context.getConsistencyLevel().isPresent() ? (ConsistencyLevel)context.getConsistencyLevel().get() : entityMeta.getWriteConsistencyLevel();
        log.trace("Write consistency level : " + writeLevel);
        return writeLevel;
    }

    public ConsistencyLevel getReadLevel(PersistentStateHolder context, PropertyMeta pm) {
        ConsistencyLevel consistency = context.getConsistencyLevel().isPresent() ? (ConsistencyLevel)context.getConsistencyLevel().get() : pm.getReadConsistencyLevel();
        log.trace("Read consistency level : " + consistency);
        return consistency;
    }

    public ConsistencyLevel getWriteLevel(PersistentStateHolder context, PropertyMeta pm) {
        ConsistencyLevel consistency = context.getConsistencyLevel().isPresent() ? (ConsistencyLevel)context.getConsistencyLevel().get() : pm.getWriteConsistencyLevel();
        log.trace("Write consistency level : " + consistency);
        return consistency;
    }
}

