/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.integration.spring;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import info.archinnov.achilles.configuration.ConfigurationParameters;
import info.archinnov.achilles.interceptor.Interceptor;
import info.archinnov.achilles.json.ObjectMapperFactory;
import info.archinnov.achilles.persistence.PersistenceManager;
import info.archinnov.achilles.persistence.PersistenceManagerFactory;
import info.archinnov.achilles.type.InsertStrategy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.validation.Validator;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class PersistenceManagerJavaConfigSample {
    @Value(value="#{cassandraProperties['achilles.entity.packages']}")
    private String entityPackages;
    @Autowired
    private List<Class<?>> entityList;
    @Value(value="#{cassandraProperties['achilles.cassandra.keyspace.name']}")
    private String keyspaceName;
    @Autowired
    private Cluster cluster;
    @Autowired
    private Session session;
    @Autowired
    private ObjectMapperFactory objecMapperFactory;
    @Autowired
    private List<Interceptor<?>> eventInterceptors;
    @Value(value="#{cassandraProperties['achilles.consistency.read.default']}")
    private String consistencyLevelReadDefault;
    @Value(value="#{cassandraProperties['achilles.consistency.write.default']}")
    private String consistencyLevelWriteDefault;
    @Value(value="#{cassandraProperties['achilles.consistency.read.map']}")
    private String consistencyLevelReadMap;
    @Value(value="#{cassandraProperties['achilles.consistency.write.map']}")
    private String consistencyLevelWriteMap;
    @Value(value="#{cassandraProperties['achilles.ddl.force.table.creation']}")
    private boolean forceTableCreation;
    @Value(value="#{cassandraProperties['achilles.bean.validation.enable']}")
    private boolean enableBeanValidation;
    @Autowired
    private Validator validator;
    private PersistenceManagerFactory pmf;
    @Value(value="#{cassandraProperties['achilles.prepared.statements.cache.size']}")
    private int preparedStatementsCacheSize;
    @Value(value="#{cassandraProperties['achilles.proxies.warm.up.disabled']}")
    private boolean disableProxiesWarmUp;
    @Value(value="#{cassandraProperties['achilles.batch.force.statements.ordering']}")
    private boolean forceBatchStatementsOrdering;
    @Autowired
    private InsertStrategy insertStrategy;
    @Autowired
    private ClassLoader osgiClassLoader;

    @PostConstruct
    public void initialize() {
        Map<ConfigurationParameters, Object> configMap = this.extractConfigParams();
        this.pmf = PersistenceManagerFactory.PersistenceManagerFactoryBuilder.build(this.cluster, configMap);
    }

    @Bean
    public PersistenceManager getPersistenceManager() {
        return this.pmf.createPersistenceManager();
    }

    private Map<ConfigurationParameters, Object> extractConfigParams() {
        HashMap<ConfigurationParameters, Object> configMap = new HashMap<ConfigurationParameters, Object>();
        configMap.put(ConfigurationParameters.ENTITY_PACKAGES, this.entityPackages);
        configMap.put(ConfigurationParameters.ENTITIES_LIST, this.entityList);
        if (this.session != null) {
            configMap.put(ConfigurationParameters.NATIVE_SESSION, this.session);
        }
        configMap.put(ConfigurationParameters.KEYSPACE_NAME, this.keyspaceName);
        configMap.put(ConfigurationParameters.OBJECT_MAPPER_FACTORY, this.objecMapperFactory);
        if (StringUtils.isNotBlank((String)this.consistencyLevelReadDefault)) {
            configMap.put(ConfigurationParameters.CONSISTENCY_LEVEL_READ_DEFAULT, this.consistencyLevelReadDefault);
        }
        if (StringUtils.isNotBlank((String)this.consistencyLevelWriteDefault)) {
            configMap.put(ConfigurationParameters.CONSISTENCY_LEVEL_WRITE_DEFAULT, this.consistencyLevelWriteDefault);
        }
        if (StringUtils.isNotBlank((String)this.consistencyLevelReadMap)) {
            configMap.put(ConfigurationParameters.CONSISTENCY_LEVEL_READ_MAP, this.extractConsistencyMap(this.consistencyLevelReadMap));
        }
        if (StringUtils.isNotBlank((String)this.consistencyLevelWriteMap)) {
            configMap.put(ConfigurationParameters.CONSISTENCY_LEVEL_WRITE_MAP, this.extractConsistencyMap(this.consistencyLevelWriteMap));
        }
        configMap.put(ConfigurationParameters.EVENT_INTERCEPTORS, this.eventInterceptors);
        configMap.put(ConfigurationParameters.FORCE_TABLE_CREATION, this.forceTableCreation);
        if (this.enableBeanValidation) {
            configMap.put(ConfigurationParameters.BEAN_VALIDATION_ENABLE, this.enableBeanValidation);
        }
        if (this.validator != null) {
            configMap.put(ConfigurationParameters.BEAN_VALIDATION_VALIDATOR, this.validator);
        }
        configMap.put(ConfigurationParameters.PREPARED_STATEMENTS_CACHE_SIZE, this.preparedStatementsCacheSize);
        configMap.put(ConfigurationParameters.PROXIES_WARM_UP_DISABLED, this.disableProxiesWarmUp);
        if (this.insertStrategy != null) {
            configMap.put(ConfigurationParameters.INSERT_STRATEGY, this.insertStrategy);
        }
        if (this.osgiClassLoader != null) {
            configMap.put(ConfigurationParameters.OSGI_CLASS_LOADER, this.osgiClassLoader);
        }
        return configMap;
    }

    private Map<String, String> extractConsistencyMap(String consistencyMapProperty) {
        HashMap<String, String> consistencyMap = new HashMap<String, String>();
        for (String entry : StringUtils.split((String)consistencyMapProperty, (String)",")) {
            String[] entryValue = StringUtils.split((String)entry, (String)":");
            assert (entryValue.length == 2) : "Invalid map value : " + entry + " for the property : " + consistencyMapProperty;
            consistencyMap.put(entryValue[0], entryValue[1]);
        }
        return consistencyMap;
    }
}

