/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.integration.spring;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import com.fasterxml.jackson.databind.ObjectMapper;
import info.archinnov.achilles.configuration.ConfigurationParameters;
import info.archinnov.achilles.json.ObjectMapperFactory;
import info.archinnov.achilles.persistence.PersistenceManager;
import info.archinnov.achilles.persistence.PersistenceManagerFactory;
import info.archinnov.achilles.type.ConsistencyLevel;
import info.archinnov.achilles.type.InsertStrategy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Validator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class PersistenceManagerFactoryBean
extends AbstractFactoryBean<PersistenceManager> {
    private static PersistenceManager manager;
    private Cluster cluster;
    private String entityPackages;
    private List<Class<?>> entityList;
    private Session session;
    private String keyspaceName;
    private ObjectMapperFactory objectMapperFactory;
    private ObjectMapper objectMapper;
    private ConsistencyLevel consistencyLevelReadDefault;
    private ConsistencyLevel consistencyLevelWriteDefault;
    private Map<String, ConsistencyLevel> consistencyLevelReadMap;
    private Map<String, ConsistencyLevel> consistencyLevelWriteMap;
    private boolean forceTableCreation = false;
    private boolean enableBeanValidation = false;
    private Validator beanValidator;
    private Integer preparedStatementCacheSize;
    private boolean disableProxiesWarmUp = true;
    private InsertStrategy insertStrategy = InsertStrategy.ALL_FIELDS;
    private ClassLoader osgiClassLoader;

    protected void initialize() {
        HashMap<ConfigurationParameters, Object> configMap = new HashMap<ConfigurationParameters, Object>();
        this.fillEntityPackages(configMap);
        this.fillEntityList(configMap);
        if (this.session != null) {
            configMap.put(ConfigurationParameters.NATIVE_SESSION, this.session);
        }
        this.fillKeyspaceName(configMap);
        this.fillObjectMapper(configMap);
        this.fillConsistencyLevels(configMap);
        configMap.put(ConfigurationParameters.FORCE_TABLE_CREATION, this.forceTableCreation);
        this.fillBeanValidation(configMap);
        if (this.preparedStatementCacheSize != null) {
            configMap.put(ConfigurationParameters.PREPARED_STATEMENTS_CACHE_SIZE, this.preparedStatementCacheSize);
        }
        configMap.put(ConfigurationParameters.PROXIES_WARM_UP_DISABLED, this.disableProxiesWarmUp);
        configMap.put(ConfigurationParameters.INSERT_STRATEGY, this.insertStrategy);
        if (this.osgiClassLoader != null) {
            configMap.put(ConfigurationParameters.OSGI_CLASS_LOADER, this.osgiClassLoader);
        }
        PersistenceManagerFactory pmf = PersistenceManagerFactory.PersistenceManagerFactoryBuilder.build(this.cluster, configMap);
        manager = pmf.createPersistenceManager();
    }

    private void fillBeanValidation(Map<ConfigurationParameters, Object> configMap) {
        configMap.put(ConfigurationParameters.BEAN_VALIDATION_ENABLE, this.enableBeanValidation);
        if (this.beanValidator != null) {
            configMap.put(ConfigurationParameters.BEAN_VALIDATION_VALIDATOR, this.beanValidator);
        }
    }

    private void fillEntityPackages(Map<ConfigurationParameters, Object> configMap) {
        if (StringUtils.isNotBlank((String)this.entityPackages)) {
            configMap.put(ConfigurationParameters.ENTITY_PACKAGES, this.entityPackages);
        }
    }

    private void fillEntityList(Map<ConfigurationParameters, Object> configMap) {
        if (CollectionUtils.isNotEmpty(this.entityList)) {
            configMap.put(ConfigurationParameters.ENTITIES_LIST, this.entityList);
        }
    }

    private void fillKeyspaceName(Map<ConfigurationParameters, Object> configMap) {
        if (StringUtils.isBlank((String)this.keyspaceName)) {
            throw new IllegalArgumentException("Keyspace name should be provided");
        }
        configMap.put(ConfigurationParameters.KEYSPACE_NAME, this.keyspaceName);
    }

    private void fillObjectMapper(Map<ConfigurationParameters, Object> configMap) {
        if (this.objectMapperFactory != null) {
            configMap.put(ConfigurationParameters.OBJECT_MAPPER_FACTORY, this.objectMapperFactory);
        }
        if (this.objectMapper != null) {
            configMap.put(ConfigurationParameters.OBJECT_MAPPER, this.objectMapper);
        }
    }

    private void fillConsistencyLevels(Map<ConfigurationParameters, Object> configMap) {
        if (this.consistencyLevelReadDefault != null) {
            configMap.put(ConfigurationParameters.CONSISTENCY_LEVEL_READ_DEFAULT, this.consistencyLevelReadDefault);
        }
        if (this.consistencyLevelWriteDefault != null) {
            configMap.put(ConfigurationParameters.CONSISTENCY_LEVEL_WRITE_DEFAULT, this.consistencyLevelWriteDefault);
        }
        if (this.consistencyLevelReadMap != null) {
            configMap.put(ConfigurationParameters.CONSISTENCY_LEVEL_READ_MAP, this.consistencyLevelReadMap);
        }
        if (this.consistencyLevelWriteMap != null) {
            configMap.put(ConfigurationParameters.CONSISTENCY_LEVEL_WRITE_MAP, this.consistencyLevelWriteMap);
        }
    }

    public void setKeyspaceName(String keyspaceName) {
        this.keyspaceName = keyspaceName;
    }

    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    public void setEntityPackages(String entityPackages) {
        this.entityPackages = entityPackages;
    }

    public void setEntityList(List<Class<?>> entityList) {
        this.entityList = entityList;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public void setEnableBeanValidation(boolean enableBeanValidation) {
        this.enableBeanValidation = enableBeanValidation;
    }

    public void setBeanValidator(Validator beanValidator) {
        this.beanValidator = beanValidator;
    }

    public void setPreparedStatementCacheSize(Integer preparedStatementCacheSize) {
        this.preparedStatementCacheSize = preparedStatementCacheSize;
    }

    public void setDisableProxiesWarmUp(boolean disableProxiesWarmUp) {
        this.disableProxiesWarmUp = disableProxiesWarmUp;
    }

    public void setInsertStrategy(InsertStrategy insertStrategy) {
        this.insertStrategy = insertStrategy;
    }

    public void setForceTableCreation(boolean forceTableCreation) {
        this.forceTableCreation = forceTableCreation;
    }

    public void setObjectMapperFactory(ObjectMapperFactory objectMapperFactory) {
        this.objectMapperFactory = objectMapperFactory;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setConsistencyLevelReadDefault(ConsistencyLevel consistencyLevelReadDefault) {
        this.consistencyLevelReadDefault = consistencyLevelReadDefault;
    }

    public void setConsistencyLevelWriteDefault(ConsistencyLevel consistencyLevelWriteDefault) {
        this.consistencyLevelWriteDefault = consistencyLevelWriteDefault;
    }

    public void setConsistencyLevelReadMap(Map<String, ConsistencyLevel> consistencyLevelReadMap) {
        this.consistencyLevelReadMap = consistencyLevelReadMap;
    }

    public void setConsistencyLevelWriteMap(Map<String, ConsistencyLevel> consistencyLevelWriteMap) {
        this.consistencyLevelWriteMap = consistencyLevelWriteMap;
    }

    public void setOsgiClassLoader(ClassLoader osgiClassLoader) {
        this.osgiClassLoader = osgiClassLoader;
    }

    public Class<?> getObjectType() {
        return PersistenceManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PersistenceManager createInstance() throws Exception {
        PersistenceManagerFactoryBean persistenceManagerFactoryBean = this;
        synchronized (persistenceManagerFactoryBean) {
            if (manager == null) {
                this.initialize();
            }
        }
        return manager;
    }
}

