/*
 * Decompiled with CFR 0.152.
 */
package global.namespace.fun.io.api;

import global.namespace.fun.io.api.Codec;
import global.namespace.fun.io.api.ConnectedCodec;
import global.namespace.fun.io.api.Filter;
import global.namespace.fun.io.api.Internal;
import global.namespace.fun.io.api.Sink;
import global.namespace.fun.io.api.Socket;
import global.namespace.fun.io.api.Source;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.OptionalLong;

public interface Store
extends Source,
Sink {
    public static final int BUFSIZE = 8192;

    public void delete() throws IOException;

    public OptionalLong size() throws IOException;

    default public boolean exists() throws IOException {
        return this.size().isPresent();
    }

    default public ConnectedCodec connect(Codec c) {
        return Internal.connect(Objects.requireNonNull(c), this);
    }

    @Override
    default public Store map(final Filter t) {
        return new Store(){

            @Override
            public Socket<OutputStream> output() {
                return t.apply(Store.this.output());
            }

            @Override
            public Socket<InputStream> input() {
                return t.unapply(Store.this.input());
            }

            @Override
            public void delete() throws IOException {
                Store.this.delete();
            }

            @Override
            public OptionalLong size() throws IOException {
                return Store.this.size();
            }
        };
    }

    default public byte[] content() throws IOException {
        try {
            return this.input().map(DataInputStream::new).apply(in -> {
                long length = this.size().getAsLong();
                if (length > Integer.MAX_VALUE) {
                    throw new IllegalStateException("Content length " + length + " exceeds Integer.MAX_VALUE.");
                }
                byte[] content = new byte[(int)length];
                in.readFully(content);
                return content;
            });
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    default public void content(byte[] content) throws IOException {
        try {
            this.acceptWriter(out -> out.write(content));
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

