/*
 * Decompiled with CFR 0.152.
 */
package global.namespace.fun.io.api;

import global.namespace.fun.io.api.Buffer;
import global.namespace.fun.io.api.ConnectedCodec;
import global.namespace.fun.io.api.Decoder;
import global.namespace.fun.io.api.Encoder;
import global.namespace.fun.io.api.Filter;
import global.namespace.fun.io.api.Internal;
import global.namespace.fun.io.api.Sink;
import global.namespace.fun.io.api.Socket;
import global.namespace.fun.io.api.Source;
import global.namespace.fun.io.api.Store;
import global.namespace.fun.io.api.function.XSupplier;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;

public interface Codec {
    public Encoder encoder(Socket<OutputStream> var1);

    default public Encoder encoder(Sink sink) {
        return this.encoder(sink.output());
    }

    public Decoder decoder(Socket<InputStream> var1);

    default public Decoder decoder(Source source) {
        return this.decoder(source.input());
    }

    default public <T> T clone(T t, XSupplier<Store> storeSupplier) throws Exception {
        return this.clone(t, () -> Buffer.of((Store)storeSupplier.get()));
    }

    default public <T> T clone(T t, Socket<Buffer> bufferSocket) throws Exception {
        return (T)bufferSocket.apply(buffer -> this.connect((Store)buffer).clone(t));
    }

    default public ConnectedCodec connect(Store store) {
        return Internal.connect(this, Objects.requireNonNull(store));
    }

    default public Codec map(final Filter t) {
        return new Codec(){

            @Override
            public Encoder encoder(Socket<OutputStream> output) {
                return Codec.this.encoder(t.apply(output));
            }

            @Override
            public Decoder decoder(Socket<InputStream> input) {
                return Codec.this.decoder(t.unapply(input));
            }
        };
    }
}

