/*
 * Decompiled with CFR 0.152.
 */
package global.namespace.fun.io.api;

import global.namespace.fun.io.api.Socket;
import global.namespace.fun.io.api.Store;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.OptionalLong;

public interface Buffer
extends Store,
Closeable {
    public static Buffer of(final Store s) {
        return new Buffer(){
            boolean closed;

            @Override
            public Socket<OutputStream> output() {
                this.check();
                return s.output();
            }

            @Override
            public Socket<InputStream> input() {
                this.check();
                return s.input();
            }

            @Override
            public void delete() throws IOException {
                this.check();
                s.delete();
            }

            @Override
            public OptionalLong size() throws IOException {
                this.check();
                return s.size();
            }

            private void check() {
                if (this.closed) {
                    throw new IllegalStateException("This buffer is already closed.");
                }
            }
        };
    }

    @Override
    default public void close() throws IOException {
        if (this.exists()) {
            this.delete();
        }
    }
}

