/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.converter.pdf.internal.stylable;

import com.lowagie.text.Element;
import fr.opensagres.xdocreport.itext.extension.ExtendedPdfPTable;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.IStylableContainer;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.StylableDocument;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.StylableTableCell;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.Style;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleTableProperties;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleTableRowProperties;

public class StylableTable
extends ExtendedPdfPTable
implements IStylableContainer {
    private final StylableDocument ownerDocument;
    private IStylableContainer parent;
    private Style lastStyleApplied = null;
    private boolean inTableHeaderRows;
    private boolean inTableRow;
    private Style currentRowStyle;

    public StylableTable(StylableDocument ownerDocument, IStylableContainer parent, int numColumns) {
        super(numColumns);
        super.setSpacingBefore(0.0f);
        super.setSplitLate(false);
        this.ownerDocument = ownerDocument;
        this.parent = parent;
    }

    public Style getCurrentRowStyle() {
        return this.currentRowStyle;
    }

    public void beginTableHeaderRows() {
        this.inTableHeaderRows = true;
    }

    public void endTableHeaderRows() {
        this.inTableHeaderRows = false;
    }

    public void beginTableRow(Style currentRowStyle) {
        this.inTableRow = true;
        this.currentRowStyle = currentRowStyle;
        if (this.inTableHeaderRows) {
            this.setHeaderRows(this.getHeaderRows() + 1);
        }
    }

    public void endTableRow() {
        while (this.currentRowIdx != 0) {
            StylableTableCell cell = new StylableTableCell(this.ownerDocument, this);
            if (this.currentRowStyle != null) {
                cell.applyStyles(this.currentRowStyle);
            }
            this.addElement((Element)cell);
        }
        this.inTableRow = false;
        this.currentRowStyle = null;
    }

    public void addElement(Element element) {
        if (this.inTableRow) {
            super.addElement(element);
        }
        if (this.currentRowIdx == 0) {
            this.endTableRow();
        }
    }

    public void applyStyles(Style style) {
        Boolean keepTogether;
        StyleTableRowProperties tableRowProperties;
        this.lastStyleApplied = style;
        StyleTableProperties tableProperties = style.getTableProperties();
        if (tableProperties != null) {
            Boolean mayBreakBetweenRows;
            Float marginBottom;
            Float marginTop;
            Float marginRight;
            Float marginLeft;
            Float margin;
            int alignment;
            if (tableProperties.getWidth() != null) {
                super.setTotalWidth(tableProperties.getWidth().floatValue());
            }
            if ((alignment = tableProperties.getAlignment()) != -1) {
                super.setHorizontalAlignment(alignment);
            }
            if ((margin = tableProperties.getMargin()) != null && margin.floatValue() > 0.0f) {
                super.setPadding(margin.floatValue());
            }
            if ((marginLeft = tableProperties.getMarginLeft()) != null && marginLeft.floatValue() > 0.0f) {
                super.setPaddingLeft(marginLeft.floatValue());
            }
            if ((marginRight = tableProperties.getMarginRight()) != null && marginRight.floatValue() > 0.0f) {
                super.setPaddingRight(marginRight.floatValue());
            }
            if ((marginTop = tableProperties.getMarginTop()) != null && marginTop.floatValue() > 0.0f) {
                super.setPaddingTop(marginTop.floatValue());
            }
            if ((marginBottom = tableProperties.getMarginBottom()) != null && marginBottom.floatValue() > 0.0f) {
                super.setPaddingBottom(marginBottom.floatValue());
            }
            if ((mayBreakBetweenRows = tableProperties.getMayBreakBetweenRows()) != null) {
                super.setKeepTogether(mayBreakBetweenRows == false);
            }
        }
        if ((tableRowProperties = style.getTableRowProperties()) != null && (keepTogether = tableRowProperties.getKeepTogether()) != null && !super.isSplitLate() && keepTogether.booleanValue()) {
            super.setSplitLate(true);
        }
    }

    public Style getLastStyleApplied() {
        return this.lastStyleApplied;
    }

    public IStylableContainer getParent() {
        return this.parent;
    }

    public StylableDocument getOwnerDocument() {
        return this.ownerDocument;
    }

    public int getColIdx() {
        return this.currentRowIdx;
    }
}

