/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.converter.pdf.internal.stylable;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import fr.opensagres.xdocreport.itext.extension.ExtendedDocument;
import fr.opensagres.xdocreport.itext.extension.IMasterPage;
import fr.opensagres.xdocreport.itext.extension.IPdfWriterConfiguration;
import fr.opensagres.xdocreport.itext.extension.PageOrientation;
import fr.opensagres.xdocreport.itext.extension.font.FontGroup;
import java.io.OutputStream;
import java.util.List;
import org.odftoolkit.odfdom.converter.core.ODFConverterException;
import org.odftoolkit.odfdom.converter.pdf.internal.StyleEngineForIText;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.IBoundsLimitContainer;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.IBreakHandlingContainer;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.IStylableContainer;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.IStylableFactory;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.StylableAnchor;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.StylableChunk;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.StylableDocumentSection;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.StylableHeaderFooter;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.StylableHeading;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.StylableImage;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.StylableList;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.StylableListItem;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.StylableMasterPage;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.StylableParagraph;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.StylablePhrase;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.StylableTab;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.StylableTable;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.StylableTableCell;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.Style;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StylePageLayoutProperties;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StylableDocument
extends ExtendedDocument
implements IStylableContainer,
IBoundsLimitContainer,
IBreakHandlingContainer,
IStylableFactory {
    private final StyleEngineForIText styleEngine;
    private Style lastStyleApplied = null;
    private StylableMasterPage activeMasterPage;
    private boolean masterPageJustChanged;
    private boolean documentEmpty = true;
    private PdfPTable layoutTable;
    private ColumnText text;
    private int colIdx;
    boolean first = true;

    public StylableDocument(OutputStream out, IPdfWriterConfiguration configuration, StyleEngineForIText styleEngine) throws DocumentException {
        super(out, configuration);
        this.styleEngine = styleEngine;
    }

    @Override
    public StylableAnchor createAnchor(IStylableContainer parent) {
        return new StylableAnchor(this, parent);
    }

    @Override
    public StylableChunk createChunk(IStylableContainer parent, String textContent, FontGroup fontGroup) {
        return new StylableChunk(this, parent, textContent, fontGroup);
    }

    @Override
    public StylableDocumentSection createDocumentSection(IStylableContainer parent, boolean inHeaderFooter) {
        return new StylableDocumentSection(this, parent, inHeaderFooter);
    }

    @Override
    public StylableHeaderFooter createHeaderFooter(boolean header) {
        return new StylableHeaderFooter(this, header);
    }

    @Override
    public StylableHeading createHeading(IStylableContainer parent, List<Integer> headingNumbering) {
        return new StylableHeading(this, parent, headingNumbering);
    }

    @Override
    public StylableImage createImage(IStylableContainer parent, Image image, Float x, Float y, Float width, Float height) {
        return new StylableImage(this, parent, image, x, y, width, height);
    }

    @Override
    public StylableList createList(IStylableContainer parent, int listLevel) {
        return new StylableList(this, parent, listLevel);
    }

    @Override
    public StylableListItem createListItem(IStylableContainer parent) {
        return new StylableListItem(this, parent);
    }

    @Override
    public StylableParagraph createParagraph(IStylableContainer parent) {
        return new StylableParagraph(this, parent);
    }

    @Override
    public StylablePhrase createPhrase(IStylableContainer parent) {
        return new StylablePhrase(this, parent);
    }

    @Override
    public StylableTab createTab(IStylableContainer parent, boolean inTableOfContent) {
        return new StylableTab(this, parent, inTableOfContent);
    }

    @Override
    public StylableTable createTable(IStylableContainer parent, int numColumns) {
        return new StylableTable(this, parent, numColumns);
    }

    @Override
    public StylableTableCell createTableCell(IStylableContainer parent) {
        return new StylableTableCell(this, parent);
    }

    public void setActiveMasterPage(IMasterPage masterPage) {
        this.flushTable();
        Style style = this.getStyleMasterPage((StylableMasterPage)masterPage);
        if (style != null) {
            this.applyStyles(style);
        }
        super.setActiveMasterPage(masterPage);
        if (this.activeMasterPage != null) {
            this.masterPageJustChanged = true;
        }
        this.activeMasterPage = (StylableMasterPage)masterPage;
        this.layoutTable = StylableDocumentSection.createLayoutTable(this.getPageWidth(), this.getAdjustedPageHeight(), style);
        this.text = StylableDocumentSection.createColumnText();
        this.setColIdx(0);
    }

    private Style setNextActiveMasterPageIfNecessary() {
        StylableMasterPage nextMasterPage;
        String nextMasterPageStyleName;
        if (this.activeMasterPage != null && (nextMasterPageStyleName = this.activeMasterPage.getNextStyleName()) != null && nextMasterPageStyleName.length() > 0 && (nextMasterPage = this.getMasterPage(nextMasterPageStyleName)) != null) {
            Style style = this.getStyleMasterPage(nextMasterPage);
            if (style != null) {
                this.applyStyles(style);
            }
            super.setActiveMasterPage((IMasterPage)nextMasterPage);
            this.activeMasterPage = nextMasterPage;
            return style;
        }
        return null;
    }

    public StylableMasterPage getActiveMasterPage() {
        return this.activeMasterPage;
    }

    public Style getStyleMasterPage(StylableMasterPage masterPage) {
        Style style = this.styleEngine.getStyle(OdfStyleFamily.List.getName(), masterPage.getPageLayoutName(), null);
        return style;
    }

    public StylableMasterPage getMasterPage(String masterPageName) {
        return (StylableMasterPage)super.getMasterPage(masterPageName);
    }

    public StylableMasterPage getDefaultMasterPage() {
        return (StylableMasterPage)super.getDefaultMasterPage();
    }

    @Override
    public void applyStyles(Style style) {
        this.lastStyleApplied = style;
        StylePageLayoutProperties pageLayoutProperties = style.getPageLayoutProperties();
        if (pageLayoutProperties != null) {
            Float width = pageLayoutProperties.getWidth();
            Float height = pageLayoutProperties.getHeight();
            if (width != null && height != null) {
                Rectangle pageSize = new Rectangle(width.floatValue(), height.floatValue());
                super.setPageSize(pageSize);
            }
            if (pageLayoutProperties.getMarginTop() != null) {
                this.originMarginTop = pageLayoutProperties.getMarginTop().floatValue();
            }
            if (pageLayoutProperties.getMarginBottom() != null) {
                this.originMarginBottom = pageLayoutProperties.getMarginBottom().floatValue();
            }
            if (pageLayoutProperties.getMarginLeft() != null) {
                this.originMarginLeft = pageLayoutProperties.getMarginLeft().floatValue();
            }
            if (pageLayoutProperties.getMarginRight() != null) {
                this.originMarginRight = pageLayoutProperties.getMarginRight().floatValue();
            }
            super.setMargins(this.originMarginLeft, this.originMarginRight, this.originMarginTop, this.originMarginBottom);
            PageOrientation orientation = pageLayoutProperties.getOrientation();
            if (orientation != null) {
                super.setOrientation(orientation);
            }
        }
    }

    @Override
    public Style getLastStyleApplied() {
        return this.lastStyleApplied;
    }

    @Override
    public IStylableContainer getParent() {
        return null;
    }

    @Override
    public Element getElement() {
        return null;
    }

    @Override
    public void addElement(Element element) {
        if (!super.isOpen()) {
            super.open();
        }
        if (this.masterPageJustChanged) {
            this.pageBreak();
        }
        this.text.addElement(element);
        StylableDocumentSection.getCell(this.layoutTable, this.colIdx).getColumn().addElement(element);
        this.simulateText();
        this.documentEmpty = false;
    }

    @Override
    public void columnBreak() {
        if (this.colIdx + 1 < this.layoutTable.getNumberOfColumns()) {
            this.setColIdx(this.colIdx + 1);
            this.simulateText();
        } else {
            this.pageBreak();
        }
    }

    @Override
    public void pageBreak() {
        if (!this.documentEmpty) {
            if (this.masterPageJustChanged) {
                this.masterPageJustChanged = false;
                super.newPage();
            } else {
                this.flushTable();
                Style nextStyle = this.setNextActiveMasterPageIfNecessary();
                super.newPage();
                this.layoutTable = nextStyle == null ? StylableDocumentSection.cloneAndClearTable(this.layoutTable, false) : StylableDocumentSection.createLayoutTable(this.getPageWidth(), this.getAdjustedPageHeight(), nextStyle);
                this.setColIdx(0);
                this.simulateText();
            }
        }
    }

    public boolean newPage() {
        throw new ODFConverterException("internal error - do not call newPage directly");
    }

    public void close() {
        this.flushTable();
        super.close();
    }

    @Override
    public float getWidthLimit() {
        PdfPCell cell = StylableDocumentSection.getCell(this.layoutTable, this.colIdx);
        return cell.getRight() - cell.getPaddingRight() - cell.getLeft() - cell.getPaddingLeft();
    }

    @Override
    public float getHeightLimit() {
        return StylableDocumentSection.getCell(this.layoutTable, this.colIdx).getFixedHeight() + this.text.getYLine();
    }

    public float getPageWidth() {
        return this.right() - this.left();
    }

    private float getAdjustedPageHeight() {
        return this.top() - this.bottom() - 0.001f;
    }

    private void setColIdx(int idx) {
        this.colIdx = idx;
        PdfPCell cell = StylableDocumentSection.getCell(this.layoutTable, this.colIdx);
        this.text.setSimpleColumn(cell.getLeft() + cell.getPaddingLeft(), -this.getAdjustedPageHeight(), cell.getRight() - cell.getPaddingRight(), 0.0f);
        cell.setColumn(ColumnText.duplicate((ColumnText)this.text));
    }

    private void simulateText() {
        int res = 0;
        try {
            res = this.text.go(true);
        }
        catch (DocumentException e) {
            throw new ODFConverterException((Throwable)e);
        }
        if (ColumnText.hasMoreText((int)res)) {
            this.columnBreak();
        }
    }

    private void flushTable() {
        if (this.layoutTable != null) {
            this.layoutTable.calculateHeights(true);
            try {
                super.add((Element)this.layoutTable);
            }
            catch (DocumentException e) {
                throw new ODFConverterException((Throwable)e);
            }
        }
    }
}

