/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.converter.pdf.internal.stylable;

import com.lowagie.text.Element;
import com.lowagie.text.pdf.PdfPCell;
import java.awt.Color;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.IBoundsLimitContainer;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.IStylableContainer;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.StylableDocument;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.StylableTable;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.StyleUtils;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.Style;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleBorder;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleTableCellProperties;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleTableRowProperties;

public class StylableTableCell
extends PdfPCell
implements IStylableContainer,
IBoundsLimitContainer {
    private final StylableDocument ownerDocument;
    private final IStylableContainer parent;
    private Style lastStyleApplied = null;

    public StylableTableCell(StylableDocument ownerDocument, IStylableContainer parent) {
        this.ownerDocument = ownerDocument;
        this.parent = parent;
        this.getColumn().setAdjustFirstLine(false);
        this.setBorder(0);
        this.setUseBorderPadding(true);
        this.setPadding(0.0f);
    }

    @Override
    public void addElement(Element element) {
        super.addElement(element);
    }

    @Override
    public void applyStyles(Style style) {
        StyleTableCellProperties tableCellProperties;
        this.lastStyleApplied = style;
        StyleTableRowProperties tableRowProperties = style.getTableRowProperties();
        if (tableRowProperties != null) {
            Float rowHeight;
            Float minRowHeight = tableRowProperties.getMinRowHeight();
            if (minRowHeight != null) {
                super.setMinimumHeight(minRowHeight.floatValue());
            }
            if ((rowHeight = tableRowProperties.getRowHeight()) != null) {
                super.setFixedHeight(rowHeight.floatValue());
            }
        }
        if ((tableCellProperties = style.getTableCellProperties()) != null) {
            int verticalAlignment;
            Float paddingRight;
            Float paddingLeft;
            Float paddingBottom;
            Float paddingTop;
            Color backgroundColor = tableCellProperties.getBackgroundColor();
            if (backgroundColor != null) {
                super.setBackgroundColor(backgroundColor);
            }
            StyleBorder border = tableCellProperties.getBorder();
            StyleUtils.applyStyles(border, this);
            StyleBorder borderTop = tableCellProperties.getBorderTop();
            StyleUtils.applyStyles(borderTop, this);
            StyleBorder borderBottom = tableCellProperties.getBorderBottom();
            StyleUtils.applyStyles(borderBottom, this);
            StyleBorder borderLeft = tableCellProperties.getBorderLeft();
            StyleUtils.applyStyles(borderLeft, this);
            StyleBorder borderRight = tableCellProperties.getBorderRight();
            StyleUtils.applyStyles(borderRight, this);
            Float padding = tableCellProperties.getPadding();
            if (padding != null) {
                super.setPadding(padding.floatValue());
            }
            if ((paddingTop = tableCellProperties.getPaddingTop()) != null) {
                super.setPaddingTop(paddingTop.floatValue());
            }
            if ((paddingBottom = tableCellProperties.getPaddingBottom()) != null) {
                super.setPaddingBottom(paddingBottom.floatValue());
            }
            if ((paddingLeft = tableCellProperties.getPaddingLeft()) != null) {
                super.setPaddingLeft(paddingLeft.floatValue());
            }
            if ((paddingRight = tableCellProperties.getPaddingRight()) != null) {
                super.setPaddingRight(paddingRight.floatValue());
            }
            if ((verticalAlignment = tableCellProperties.getVerticalAlignment()) != -1) {
                super.setVerticalAlignment(verticalAlignment);
            }
        }
    }

    @Override
    public Style getLastStyleApplied() {
        return this.lastStyleApplied;
    }

    @Override
    public IStylableContainer getParent() {
        return this.parent;
    }

    @Override
    public Element getElement() {
        return this;
    }

    @Override
    public float getWidthLimit() {
        float width = 0.0f;
        if (this.parent != null && this.parent instanceof StylableTable) {
            StylableTable table = (StylableTable)this.parent;
            int colIdx = table.getColIdx();
            float[] widths = table.getAbsoluteWidths();
            for (int i = 0; i < this.getColspan(); ++i) {
                width += widths[colIdx + i];
            }
        }
        return width > 0.0f ? width : this.ownerDocument.getPageWidth();
    }

    @Override
    public float getHeightLimit() {
        return -1.0f;
    }
}

