/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.converter.pdf.internal.stylable;

import com.lowagie.text.Chunk;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Phrase;
import java.util.ArrayList;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.IStylableContainer;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.IStylableFactory;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.Style;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleTextProperties;

public class StylablePhrase
extends Phrase
implements IStylableContainer {
    private static final long serialVersionUID = 664309269352903329L;
    private IStylableContainer parent;
    private Style lastStyleApplied = null;

    public StylablePhrase(IStylableFactory ownerDocument, IStylableContainer parent) {
        this.parent = parent;
    }

    @Override
    public void addElement(Element element) {
        super.add(this.size(), (Object)element);
    }

    @Override
    public void applyStyles(Style style) {
        Font font;
        this.lastStyleApplied = style;
        StyleTextProperties textProperties = style.getTextProperties();
        if (textProperties != null && (font = textProperties.getFont()) != null) {
            super.setFont(font);
        }
    }

    @Override
    public Style getLastStyleApplied() {
        return this.lastStyleApplied;
    }

    @Override
    public IStylableContainer getParent() {
        return this.parent;
    }

    @Override
    public Element getElement() {
        boolean empty = true;
        ArrayList chunks = this.getChunks();
        for (Chunk chunk : chunks) {
            if (chunk.getImage() != null || chunk.getContent() == null || chunk.getContent().length() <= 0) continue;
            empty = false;
            break;
        }
        if (empty) {
            super.add((Object)new Chunk("\t"));
        }
        return this;
    }
}

