/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.model.materials;

import fi.foyt.fni.persistence.model.materials.Material;
import fi.foyt.fni.persistence.model.materials.MaterialType;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringEscapeUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.search.annotations.Indexed;

@Entity
@Cacheable(value=true)
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@PrimaryKeyJoinColumn(name="id")
@Indexed
public class Document
extends Material {
    @Column
    @Lob
    private String data;

    public Document() {
        this.setType(MaterialType.DOCUMENT);
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    @Transient
    public String getContentPlain() {
        return StringEscapeUtils.unescapeHtml4((String)this.getData().replaceAll("\\<.*?>", ""));
    }
}

