/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.model.gamelibrary;

import fi.foyt.fni.persistence.model.common.Language;
import fi.foyt.fni.persistence.model.forum.ForumTopic;
import fi.foyt.fni.persistence.model.gamelibrary.PublicationImage;
import fi.foyt.fni.persistence.model.users.User;
import java.util.Date;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Cacheable(value=true)
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class Publication {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @DocumentId
    private Long id;
    @NotNull
    @Column(nullable=false, columnDefinition="BIT")
    @Field
    private Boolean published;
    @NotNull
    @NotEmpty
    @Column(nullable=false)
    @Field
    private String name;
    @NotNull
    @NotEmpty
    @Column(nullable=false)
    private String urlName;
    @Lob
    private String description;
    @NotNull
    @Column(nullable=false)
    private Double price;
    @NotNull
    @Column(nullable=false)
    private Double authorsShare;
    @ManyToOne
    private PublicationImage defaultImage;
    @NotNull
    @Column(nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date modified;
    @NotNull
    @Column(nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date created;
    @ManyToOne
    private User creator;
    @ManyToOne
    private User modifier;
    private Double weight;
    private Integer width;
    private Integer height;
    private Integer depth;
    @ManyToOne
    private ForumTopic forumTopic;
    @ManyToOne
    private Language language;

    public Long getId() {
        return this.id;
    }

    public Boolean getPublished() {
        return this.published;
    }

    public void setPublished(Boolean published) {
        this.published = published;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrlName() {
        return this.urlName;
    }

    public void setUrlName(String urlName) {
        this.urlName = urlName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Double getPrice() {
        return this.price;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    public Double getAuthorsShare() {
        return this.authorsShare;
    }

    public void setAuthorsShare(Double authorsShare) {
        this.authorsShare = authorsShare;
    }

    public PublicationImage getDefaultImage() {
        return this.defaultImage;
    }

    public void setDefaultImage(PublicationImage defaultImage) {
        this.defaultImage = defaultImage;
    }

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public User getCreator() {
        return this.creator;
    }

    public void setCreator(User creator) {
        this.creator = creator;
    }

    public User getModifier() {
        return this.modifier;
    }

    public void setModifier(User modifier) {
        this.modifier = modifier;
    }

    public Double getWeight() {
        return this.weight;
    }

    public void setWeight(Double weight) {
        this.weight = weight;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public Integer getDepth() {
        return this.depth;
    }

    public void setDepth(Integer depth) {
        this.depth = depth;
    }

    public ForumTopic getForumTopic() {
        return this.forumTopic;
    }

    public void setForumTopic(ForumTopic forumTopic) {
        this.forumTopic = forumTopic;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    @Transient
    @Field
    public String getDescriptionPlain() {
        if (this.getDescription() == null) {
            return null;
        }
        return StringEscapeUtils.unescapeHtml4((String)this.getDescription().replaceAll("\\<.*?>", ""));
    }

    @Transient
    public String getDescriptionPlainAbbr() {
        if (this.getDescription() == null) {
            return null;
        }
        return StringUtils.abbreviate((String)this.getDescriptionPlain(), (int)255);
    }
}

