/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.model.forum;

import fi.foyt.fni.persistence.model.forum.ForumMessage;
import fi.foyt.fni.persistence.model.forum.ForumTopic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringEscapeUtils;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;

@Entity
@PrimaryKeyJoinColumn(name="id")
@Indexed
public class ForumPost
extends ForumMessage {
    @ManyToOne
    private ForumTopic topic;
    @Column(nullable=false)
    @Lob
    private String content;

    public ForumTopic getTopic() {
        return this.topic;
    }

    public void setTopic(ForumTopic topic) {
        this.topic = topic;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @Transient
    @Field
    public String getTopicSubject() {
        return this.getTopic().getSubject();
    }

    @Transient
    @Field
    public String getContentPlain() {
        return StringEscapeUtils.unescapeHtml4((String)this.getContent().replaceAll("\\<.*?>", ""));
    }
}

