/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.model.blog;

import fi.foyt.fni.persistence.model.blog.BlogCategory;
import fi.foyt.fni.persistence.model.users.User;
import java.util.Date;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
@Cacheable(value=true)
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class BlogEntry {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @NotNull
    @NotEmpty
    @Column(nullable=false, unique=true)
    private String guid;
    @ManyToOne
    private BlogCategory category;
    private String urlName;
    @NotNull
    @NotEmpty
    @Column(nullable=false)
    private String title;
    @NotNull
    @NotEmpty
    @Column(nullable=false)
    @Lob
    private String summary;
    @Lob
    private String content;
    private String link;
    private String authorName;
    @NotNull
    @Column(nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date modified;
    @NotNull
    @Column(nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date created;
    @ManyToOne
    private User creator;
    @ManyToOne
    private User modifier;

    public Long getId() {
        return this.id;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public BlogCategory getCategory() {
        return this.category;
    }

    public void setCategory(BlogCategory category) {
        this.category = category;
    }

    public String getUrlName() {
        return this.urlName;
    }

    public void setUrlName(String urlName) {
        this.urlName = urlName;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public void setAuthorName(String authorName) {
        this.authorName = authorName;
    }

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public User getCreator() {
        return this.creator;
    }

    public void setCreator(User creator) {
        this.creator = creator;
    }

    public User getModifier() {
        return this.modifier;
    }

    public void setModifier(User modifier) {
        this.modifier = modifier;
    }
}

