/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.users;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.auth.UserIdentifier;
import fi.foyt.fni.persistence.model.users.UserToken;
import fi.foyt.fni.persistence.model.users.UserToken_;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class UserTokenDAO
extends GenericDAO<UserToken> {
    private static final long serialVersionUID = 1L;

    public UserToken create(UserIdentifier userIdentifier, String token, String secret, Date expires, String grantedScopes) {
        EntityManager entityManager = this.getEntityManager();
        UserToken userToken = new UserToken();
        userToken.setToken(token);
        userToken.setSecret(secret);
        userToken.setExpires(expires);
        userToken.setGrantedScopes(grantedScopes);
        userToken.setUserIdentifier(userIdentifier);
        entityManager.persist((Object)userToken);
        return userToken;
    }

    public UserToken findByToken(String token) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(UserToken.class);
        Root root = criteria.from(UserToken.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(UserToken_.token), (Object)token));
        return (UserToken)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }

    public UserToken findByUserIdentifier(UserIdentifier userIdentifier) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(UserToken.class);
        Root root = criteria.from(UserToken.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(UserToken_.userIdentifier), (Object)userIdentifier));
        return (UserToken)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }

    public List<UserToken> listByUserIdentifier(UserIdentifier userIdentifier) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(UserToken.class);
        Root root = criteria.from(UserToken.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(UserToken_.userIdentifier), (Object)userIdentifier));
        return entityManager.createQuery(criteria).getResultList();
    }
}

