/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.users;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.users.CommonFriend;
import fi.foyt.fni.persistence.model.users.User;
import fi.foyt.fni.persistence.model.users.UserFriend;
import fi.foyt.fni.persistence.model.users.UserFriend_;
import fi.foyt.fni.persistence.model.users.User_;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;

public class UserFriendDAO
extends GenericDAO<UserFriend> {
    private static final long serialVersionUID = 1L;

    public UserFriend create(User user, User friend, Boolean confirmed) {
        EntityManager entityManager = this.getEntityManager();
        UserFriend userFriend = new UserFriend();
        userFriend.setFriend(friend);
        userFriend.setUser(user);
        userFriend.setConfirmed(confirmed);
        entityManager.persist((Object)userFriend);
        return userFriend;
    }

    public UserFriend findByUserAndFriend(User user, User friend) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(UserFriend.class);
        Root root = criteria.from(UserFriend.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(UserFriend_.user), (Object)user), (Expression)criteriaBuilder.equal((Expression)root.get(UserFriend_.friend), (Object)friend)));
        return (UserFriend)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }

    public List<UserFriend> listByUser(User user) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(UserFriend.class);
        Root root = criteria.from(UserFriend.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(UserFriend_.user), (Object)user));
        return entityManager.createQuery(criteria).getResultList();
    }

    public List<UserFriend> listByUserAndConfirmed(User user, Boolean confirmed) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(UserFriend.class);
        Root root = criteria.from(UserFriend.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(UserFriend_.user), (Object)user), (Expression)criteriaBuilder.equal((Expression)root.get(UserFriend_.confirmed), (Object)confirmed)));
        return entityManager.createQuery(criteria).getResultList();
    }

    public List<UserFriend> listByFriend(User friend) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(UserFriend.class);
        Root root = criteria.from(UserFriend.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(UserFriend_.friend), (Object)friend));
        return entityManager.createQuery(criteria).getResultList();
    }

    public List<UserFriend> listByFriendAndConfirmed(User friend, Boolean confirmed) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(UserFriend.class);
        Root root = criteria.from(UserFriend.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(UserFriend_.friend), (Object)friend), (Expression)criteriaBuilder.equal((Expression)root.get(UserFriend_.confirmed), (Object)confirmed)));
        return entityManager.createQuery(criteria).getResultList();
    }

    public List<User> listFriendUsersByConfirmed(User user, Boolean confirmed) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder friendUsersCriteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery friendUsersCriteria = friendUsersCriteriaBuilder.createQuery(Long.class);
        Root friendUsersRoot = friendUsersCriteria.from(UserFriend.class);
        Join friendUsersUserJoin = friendUsersRoot.join(UserFriend_.user);
        friendUsersCriteria.select((Selection)friendUsersUserJoin.get(User_.id));
        friendUsersCriteria.where((Expression)friendUsersCriteriaBuilder.and((Expression)friendUsersCriteriaBuilder.equal((Expression)friendUsersRoot.get(UserFriend_.friend), (Object)user), (Expression)friendUsersCriteriaBuilder.equal((Expression)friendUsersRoot.get(UserFriend_.confirmed), (Object)confirmed)));
        CriteriaBuilder userFriendsCriteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery userFriendsCriteria = userFriendsCriteriaBuilder.createQuery(Long.class);
        Root userFriendsRoot = userFriendsCriteria.from(UserFriend.class);
        Join usersFriendsUserJoin = userFriendsRoot.join(UserFriend_.friend);
        userFriendsCriteria.select((Selection)usersFriendsUserJoin.get(User_.id));
        userFriendsCriteria.where((Expression)userFriendsCriteriaBuilder.and((Expression)userFriendsCriteriaBuilder.equal((Expression)userFriendsRoot.get(UserFriend_.user), (Object)user), (Expression)userFriendsCriteriaBuilder.equal((Expression)userFriendsRoot.get(UserFriend_.confirmed), (Object)confirmed)));
        List friendIds = entityManager.createQuery(userFriendsCriteria).getResultList();
        friendIds.addAll(entityManager.createQuery(friendUsersCriteria).getResultList());
        if (friendIds.size() > 0) {
            CriteriaBuilder userCriteriaBuilder = entityManager.getCriteriaBuilder();
            CriteriaQuery userCriteria = userCriteriaBuilder.createQuery(User.class);
            Root userRoot = userCriteria.from(User.class);
            userCriteria.select((Selection)userRoot);
            userCriteria.where((Expression)userRoot.get(User_.id).in((Collection)friendIds));
            return entityManager.createQuery(userCriteria).getResultList();
        }
        return new ArrayList<User>();
    }

    public List<CommonFriend> listCommonFriendsByUserOrderByCommonFriendCount(User user) {
        return this.listCommonFriendsByUserOrderByCommonFriendCount(user, null, null);
    }

    public List<CommonFriend> listCommonFriendsByUserOrderByCommonFriendCount(User user, Integer firstResult, Integer maxResults) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createTupleQuery();
        Root root = criteria.from(UserFriend.class);
        Path friendPath = root.get(UserFriend_.friend);
        Expression countExpression = criteriaBuilder.count((Expression)friendPath);
        Subquery friendsSubquery = criteria.subquery(User.class);
        Root friendsRoot = friendsSubquery.from(UserFriend.class);
        friendsSubquery.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)friendsRoot.get(UserFriend_.user), (Object)user), (Expression)criteriaBuilder.equal((Expression)root.get(UserFriend_.confirmed), (Object)Boolean.TRUE)));
        friendsSubquery.select((Expression)friendsRoot.get(UserFriend_.friend));
        criteria.multiselect(new Selection[]{friendPath, countExpression});
        criteria.where((Expression)criteriaBuilder.and(new Predicate[]{criteriaBuilder.notEqual((Expression)root.get(UserFriend_.friend), (Object)user), root.get(UserFriend_.user).in(new Expression[]{friendsSubquery}), criteriaBuilder.not((Expression)root.get(UserFriend_.friend).in(new Expression[]{friendsSubquery})), criteriaBuilder.equal((Expression)root.get(UserFriend_.confirmed), (Object)Boolean.TRUE)}));
        criteria.groupBy(new Expression[]{friendPath});
        criteria.orderBy(new Order[]{criteriaBuilder.desc(countExpression)});
        ArrayList<CommonFriend> commonFriends = new ArrayList<CommonFriend>();
        TypedQuery query = entityManager.createQuery(criteria);
        if (firstResult != null) {
            query.setFirstResult(firstResult.intValue());
        }
        if (maxResults != null) {
            query.setMaxResults(maxResults.intValue());
        }
        List tuples = query.getResultList();
        for (Tuple tuple : tuples) {
            commonFriends.add(new CommonFriend((Long)tuple.get((TupleElement)countExpression), (User)tuple.get((TupleElement)friendPath)));
        }
        return commonFriends;
    }

    public UserFriend updateConfirmed(UserFriend userFriend, Boolean confirmed) {
        EntityManager entityManager = this.getEntityManager();
        userFriend.setConfirmed(confirmed);
        entityManager.persist((Object)userFriend);
        return userFriend;
    }
}

