/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.users;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.users.User;
import fi.foyt.fni.persistence.model.users.UserEmail;
import fi.foyt.fni.persistence.model.users.UserEmail_;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class UserEmailDAO
extends GenericDAO<UserEmail> {
    private static final long serialVersionUID = 1L;

    public UserEmail create(User user, String email, Boolean primary) {
        EntityManager entityManager = this.getEntityManager();
        UserEmail userEmail = new UserEmail();
        userEmail.setEmail(email);
        userEmail.setUser(user);
        userEmail.setPrimary(primary);
        entityManager.persist((Object)userEmail);
        return userEmail;
    }

    public UserEmail findByEmail(String email) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(UserEmail.class);
        Root root = criteria.from(UserEmail.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(UserEmail_.email), (Object)email));
        return (UserEmail)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }

    public UserEmail findByUserAndPrimary(User user, Boolean primary) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(UserEmail.class);
        Root root = criteria.from(UserEmail.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(UserEmail_.user), (Object)user), (Expression)criteriaBuilder.equal((Expression)root.get(UserEmail_.primary), (Object)primary)));
        return (UserEmail)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }

    public List<UserEmail> listByUser(User user) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(UserEmail.class);
        Root root = criteria.from(UserEmail.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(UserEmail_.user), (Object)user));
        return entityManager.createQuery(criteria).getResultList();
    }

    public List<User> listUsersByEmails(List<String> emails) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(User.class);
        Root root = criteria.from(UserEmail.class);
        criteria.select((Selection)root.get(UserEmail_.user));
        criteria.where((Expression)root.get(UserEmail_.email).in(emails));
        criteria.groupBy(new Expression[]{root.get(UserEmail_.user)});
        return entityManager.createQuery(criteria).getResultList();
    }

    public Long countByUser(User user) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Long.class);
        Root root = criteria.from(UserEmail.class);
        criteria.select((Selection)criteriaBuilder.count((Expression)root));
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(UserEmail_.user), (Object)user));
        return (Long)entityManager.createQuery(criteria).getSingleResult();
    }
}

