/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.users;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.users.User;
import fi.foyt.fni.persistence.model.users.UserProfileImageSource;
import fi.foyt.fni.persistence.model.users.UserRole;
import fi.foyt.fni.persistence.model.users.User_;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class UserDAO
extends GenericDAO<User> {
    private static final long serialVersionUID = 1L;

    public User create(String firstName, String lastName, String nickname, Locale locale, Date registrationDate, UserRole role, UserProfileImageSource profileImageSource) {
        EntityManager entityManager = this.getEntityManager();
        User user = new User();
        user.setArchived(Boolean.FALSE);
        user.setFirstName(firstName);
        user.setLastName(lastName);
        user.setLocale(locale.toString());
        user.setNickname(nickname);
        user.setPremiumExpires(null);
        user.setRole(role);
        user.setRegistrationDate(registrationDate);
        user.setProfileImageSource(profileImageSource);
        entityManager.persist((Object)user);
        return user;
    }

    public List<User> listByArchived(Boolean archived) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(User.class);
        Root root = criteria.from(User.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(User_.archived), (Object)archived));
        return entityManager.createQuery(criteria).getResultList();
    }

    public List<User> listByArchivedAndRoleIn(Boolean archived, List<UserRole> roles) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(User.class);
        Root root = criteria.from(User.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)root.get(User_.role).in(roles), (Expression)criteriaBuilder.equal((Expression)root.get(User_.archived), (Object)archived)));
        return entityManager.createQuery(criteria).getResultList();
    }

    public User updateFirstName(User user, String firstName) {
        EntityManager entityManager = this.getEntityManager();
        user.setFirstName(firstName);
        entityManager.persist((Object)user);
        return user;
    }

    public User updateLastName(User user, String lastName) {
        EntityManager entityManager = this.getEntityManager();
        user.setLastName(lastName);
        entityManager.persist((Object)user);
        return user;
    }

    public User updateNickname(User user, String nickname) {
        EntityManager entityManager = this.getEntityManager();
        user.setNickname(nickname);
        entityManager.persist((Object)user);
        return user;
    }

    public User updateLocale(User user, Locale locale) {
        EntityManager entityManager = this.getEntityManager();
        user.setLocale(locale.toString());
        entityManager.persist((Object)user);
        return user;
    }

    public User updateRegistrationDate(User user, Date registrationDate) {
        EntityManager entityManager = this.getEntityManager();
        user.setRegistrationDate(registrationDate);
        entityManager.persist((Object)user);
        return user;
    }

    public User updateArchived(User user, Boolean archived) {
        EntityManager entityManager = this.getEntityManager();
        user.setArchived(archived);
        entityManager.persist((Object)user);
        return user;
    }

    public User updateRole(User user, UserRole role) {
        EntityManager entityManager = this.getEntityManager();
        user.setRole(role);
        entityManager.persist((Object)user);
        return user;
    }

    public User updateAbout(User user, String about) {
        user.setAbout(about);
        return this.persist(user);
    }

    public User updateCompany(User user, String company) {
        user.setCompany(company);
        return this.persist(user);
    }

    public User updateMobile(User user, String mobile) {
        user.setMobile(mobile);
        return this.persist(user);
    }

    public User updatePhone(User user, String phone) {
        user.setPhone(phone);
        return this.persist(user);
    }

    public User updateProfileImageSource(User user, UserProfileImageSource profileImageSource) {
        user.setProfileImageSource(profileImageSource);
        return this.persist(user);
    }
}

