/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.users;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.common.Country;
import fi.foyt.fni.persistence.model.users.Address;
import fi.foyt.fni.persistence.model.users.AddressType;
import fi.foyt.fni.persistence.model.users.Address_;
import fi.foyt.fni.persistence.model.users.User;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class AddressDAO
extends GenericDAO<Address> {
    private static final long serialVersionUID = 1L;

    public Address create(User user, AddressType addressType, String street1, String street2, String postalCode, String city, Country country) {
        Address address = new Address();
        address.setAddressType(addressType);
        address.setCity(city);
        address.setCountry(country);
        address.setPostalCode(postalCode);
        address.setStreet1(street1);
        address.setStreet2(street2);
        address.setUser(user);
        return this.persist(address);
    }

    public Address findByUserAndAddressType(User user, AddressType addressType) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Address.class);
        Root root = criteria.from(Address.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(Address_.user), (Object)user), (Expression)criteriaBuilder.equal((Expression)root.get(Address_.addressType), (Object)addressType)));
        return (Address)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }

    public Address updateCity(Address address, String city) {
        address.setCity(city);
        return this.persist(address);
    }

    public Address updateCountry(Address address, Country country) {
        address.setCountry(country);
        return this.persist(address);
    }

    public Address updatePostalCode(Address address, String postalCode) {
        address.setPostalCode(postalCode);
        return this.persist(address);
    }

    public Address updateStreet1(Address address, String street1) {
        address.setStreet1(street1);
        return this.persist(address);
    }

    public Address updateStreet2(Address address, String street2) {
        address.setStreet2(street2);
        return this.persist(address);
    }
}

