/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.store;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.store.StoreProduct;
import fi.foyt.fni.persistence.model.store.StoreProductTag;
import fi.foyt.fni.persistence.model.store.StoreProductTag_;
import fi.foyt.fni.persistence.model.store.StoreProduct_;
import fi.foyt.fni.persistence.model.store.StoreTag;
import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class StoreProductTagDAO
extends GenericDAO<StoreProductTag> {
    private static final long serialVersionUID = 1L;

    public StoreProductTag create(StoreTag tag, StoreProduct product) {
        StoreProductTag storeProductTag = new StoreProductTag();
        storeProductTag.setProduct(product);
        storeProductTag.setTag(tag);
        return this.persist(storeProductTag);
    }

    public StoreProductTag findByProductAndTag(StoreProduct product, StoreTag tag) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(StoreProductTag.class);
        Root root = criteria.from(StoreProductTag.class);
        criteria.select((Selection)root);
        criteria.where(new Predicate[]{criteriaBuilder.equal((Expression)root.get(StoreProductTag_.product), (Object)product), criteriaBuilder.equal((Expression)root.get(StoreProductTag_.tag), (Object)tag)});
        return (StoreProductTag)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }

    public List<StoreProductTag> listByProduct(StoreProduct product) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(StoreProductTag.class);
        Root root = criteria.from(StoreProductTag.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(StoreProductTag_.product), (Object)product));
        return entityManager.createQuery(criteria).getResultList();
    }

    public List<StoreProduct> listProductsByStoreTags(List<StoreTag> storeTags) {
        if (storeTags.isEmpty()) {
            return Collections.emptyList();
        }
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(StoreProduct.class);
        Root root = criteria.from(StoreProductTag.class);
        criteria.select((Selection)root.get(StoreProductTag_.product)).distinct(true);
        criteria.where((Expression)root.get(StoreProductTag_.tag).in(storeTags));
        return entityManager.createQuery(criteria).getResultList();
    }

    public Long countProductsByTag(StoreTag tag) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Long.class);
        Root root = criteria.from(StoreProductTag.class);
        criteria.select((Selection)criteriaBuilder.count((Expression)root.get(StoreProductTag_.product)));
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(StoreProductTag_.tag), (Object)tag));
        return (Long)entityManager.createQuery(criteria).getSingleResult();
    }

    public List<StoreTag> listStoreTagsByProductPublished(Boolean published) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(StoreTag.class);
        Root root = criteria.from(StoreProductTag.class);
        Join join = root.join(StoreProductTag_.product);
        criteria.select((Selection)root.get(StoreProductTag_.tag)).distinct(true);
        criteria.where((Expression)criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)join.get(StoreProduct_.published), (Object)published)}));
        return entityManager.createQuery(criteria).getResultList();
    }
}

