/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.oauth;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.oauth.OAuthClient;
import fi.foyt.fni.persistence.model.oauth.OAuthClientType;
import fi.foyt.fni.persistence.model.oauth.OAuthClient_;
import fi.foyt.fni.persistence.model.users.User;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class OAuthClientDAO
extends GenericDAO<OAuthClient> {
    private static final long serialVersionUID = 1L;

    public OAuthClient create(String name, OAuthClientType type, String clientId, String clientSecret, String redirectUrl, User serviceUser) {
        OAuthClient oAuthClient = new OAuthClient();
        oAuthClient.setClientId(clientId);
        oAuthClient.setClientSecret(clientSecret);
        oAuthClient.setName(name);
        oAuthClient.setRedirectUrl(redirectUrl);
        oAuthClient.setType(type);
        oAuthClient.setServiceUser(serviceUser);
        return this.persist(oAuthClient);
    }

    public OAuthClient findByClientId(String clientId) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(OAuthClient.class);
        Root root = criteria.from(OAuthClient.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(OAuthClient_.clientId), (Object)clientId));
        return (OAuthClient)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }

    public OAuthClient findByClientIdAndClientSecret(String clientId, String clientSecret) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(OAuthClient.class);
        Root root = criteria.from(OAuthClient.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(OAuthClient_.clientId), (Object)clientId), (Expression)criteriaBuilder.equal((Expression)root.get(OAuthClient_.clientSecret), (Object)clientSecret)));
        return (OAuthClient)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }
}

