/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.oauth;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.oauth.OAuthAuthorizationCode;
import fi.foyt.fni.persistence.model.oauth.OAuthAuthorizationCode_;
import fi.foyt.fni.persistence.model.oauth.OAuthClient;
import fi.foyt.fni.persistence.model.users.User;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class OAuthAuthorizationCodeDAO
extends GenericDAO<OAuthAuthorizationCode> {
    private static final long serialVersionUID = 1L;

    public OAuthAuthorizationCode create(OAuthClient client, User user, String code) {
        OAuthAuthorizationCode oAuthAuthorizationCode = new OAuthAuthorizationCode();
        oAuthAuthorizationCode.setClient(client);
        oAuthAuthorizationCode.setCode(code);
        oAuthAuthorizationCode.setUser(user);
        return this.persist(oAuthAuthorizationCode);
    }

    public OAuthAuthorizationCode findByClientAndCode(OAuthClient client, String code) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(OAuthAuthorizationCode.class);
        Root root = criteria.from(OAuthAuthorizationCode.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(OAuthAuthorizationCode_.client), (Object)client), (Expression)criteriaBuilder.equal((Expression)root.get(OAuthAuthorizationCode_.code), (Object)code)));
        return (OAuthAuthorizationCode)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }
}

