/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.oauth;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.oauth.OAuthAccessToken;
import fi.foyt.fni.persistence.model.oauth.OAuthAccessToken_;
import fi.foyt.fni.persistence.model.oauth.OAuthAuthorizationCode;
import fi.foyt.fni.persistence.model.oauth.OAuthClient;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class OAuthAccessTokenDAO
extends GenericDAO<OAuthAccessToken> {
    private static final long serialVersionUID = 1L;

    public OAuthAccessToken create(OAuthClient client, OAuthAuthorizationCode authorizationCode, String accessToken, Long expires) {
        OAuthAccessToken oAuthAccessToken = new OAuthAccessToken();
        oAuthAccessToken.setAccessToken(accessToken);
        oAuthAccessToken.setAuthorizationCode(authorizationCode);
        oAuthAccessToken.setExpires(expires);
        oAuthAccessToken.setClient(client);
        return this.persist(oAuthAccessToken);
    }

    public OAuthAccessToken findByAccessToken(String accessToken) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(OAuthAccessToken.class);
        Root root = criteria.from(OAuthAccessToken.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(OAuthAccessToken_.accessToken), (Object)accessToken));
        return (OAuthAccessToken)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }
}

