/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.messages;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.messages.Message;
import fi.foyt.fni.persistence.model.messages.MessageFolder;
import fi.foyt.fni.persistence.model.messages.Message_;
import fi.foyt.fni.persistence.model.messages.RecipientMessage;
import fi.foyt.fni.persistence.model.messages.RecipientMessage_;
import fi.foyt.fni.persistence.model.users.User;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class RecipientMessageDAO
extends GenericDAO<RecipientMessage> {
    private static final long serialVersionUID = 1L;

    public RecipientMessage create(Message message, User recipient, MessageFolder folder, Boolean read, Boolean starred, Boolean removed) {
        RecipientMessage recipientMessage = new RecipientMessage();
        recipientMessage.setFolder(folder);
        recipientMessage.setMessage(message);
        recipientMessage.setRead(read);
        recipientMessage.setRecipient(recipient);
        recipientMessage.setStarred(starred);
        recipientMessage.setRemoved(removed);
        this.getEntityManager().persist((Object)recipientMessage);
        return recipientMessage;
    }

    public RecipientMessage findByMessageAndRecipient(Message message, User recipient) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(RecipientMessage.class);
        Root root = criteria.from(RecipientMessage.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(RecipientMessage_.recipient), (Object)recipient), (Expression)criteriaBuilder.equal((Expression)root.get(RecipientMessage_.message), (Object)message)));
        return (RecipientMessage)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }

    public List<RecipientMessage> listByRecipient(User recipient) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(RecipientMessage.class);
        Root root = criteria.from(RecipientMessage.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(RecipientMessage_.recipient), (Object)recipient));
        return entityManager.createQuery(criteria).getResultList();
    }

    public List<RecipientMessage> listBySender(User sender) {
        return this.listBySender(sender, null, null);
    }

    public List<RecipientMessage> listBySender(User sender, Integer firstResult, Integer maxResults) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(RecipientMessage.class);
        Root root = criteria.from(RecipientMessage.class);
        Join messageJoin = root.join(RecipientMessage_.message);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)messageJoin.get(Message_.sender), (Object)sender));
        TypedQuery query = entityManager.createQuery(criteria);
        if (firstResult != null) {
            query.setFirstResult(firstResult.intValue());
        }
        if (maxResults != null) {
            query.setMaxResults(maxResults.intValue());
        }
        return query.getResultList();
    }

    public List<RecipientMessage> listByFolder(MessageFolder folder) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(RecipientMessage.class);
        Root root = criteria.from(RecipientMessage.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(RecipientMessage_.folder), (Object)folder));
        return entityManager.createQuery(criteria).getResultList();
    }

    public List<RecipientMessage> listByRecipientAndStarred(User recipient, Boolean starred) {
        return this.listByRecipientAndStarred(recipient, starred, null, null);
    }

    public List<RecipientMessage> listByRecipientAndStarred(User recipient, Boolean starred, Integer firstResult, Integer maxResults) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(RecipientMessage.class);
        Root root = criteria.from(RecipientMessage.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(RecipientMessage_.starred), (Object)starred), (Expression)criteriaBuilder.equal((Expression)root.get(RecipientMessage_.recipient), (Object)recipient)));
        TypedQuery query = entityManager.createQuery(criteria);
        if (firstResult != null) {
            query.setFirstResult(firstResult.intValue());
        }
        if (maxResults != null) {
            query.setMaxResults(maxResults.intValue());
        }
        return query.getResultList();
    }

    public List<RecipientMessage> listByRootFolderAndRecipientAndRemoved(User recipient, Boolean removed) {
        return this.listByRootFolderAndRecipientAndRemoved(recipient, removed, null, null);
    }

    public List<RecipientMessage> listByRootFolderAndRecipientAndRemoved(User recipient, Boolean removed, Integer firstResult, Integer maxResults) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(RecipientMessage.class);
        Root root = criteria.from(RecipientMessage.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and(new Predicate[]{criteriaBuilder.isNull((Expression)root.get(RecipientMessage_.folder)), criteriaBuilder.equal((Expression)root.get(RecipientMessage_.recipient), (Object)recipient), criteriaBuilder.equal((Expression)root.get(RecipientMessage_.removed), (Object)removed)}));
        TypedQuery query = entityManager.createQuery(criteria);
        if (firstResult != null) {
            query.setFirstResult(firstResult.intValue());
        }
        if (maxResults != null) {
            query.setMaxResults(maxResults.intValue());
        }
        return query.getResultList();
    }

    public RecipientMessage updateFolder(RecipientMessage recipientMessage, MessageFolder folder) {
        recipientMessage.setFolder(folder);
        this.getEntityManager().persist((Object)recipientMessage);
        return recipientMessage;
    }

    public List<RecipientMessage> listByRecipientAndRemoved(User recipient, Boolean removed) {
        return this.listByRecipientAndRemoved(recipient, removed, null, null);
    }

    public List<RecipientMessage> listByRecipientAndRemoved(User recipient, Boolean removed, Integer firstResult, Integer maxResults) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(RecipientMessage.class);
        Root root = criteria.from(RecipientMessage.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(RecipientMessage_.recipient), (Object)recipient), (Expression)criteriaBuilder.equal((Expression)root.get(RecipientMessage_.removed), (Object)removed)));
        TypedQuery query = entityManager.createQuery(criteria);
        if (firstResult != null) {
            query.setFirstResult(firstResult.intValue());
        }
        if (maxResults != null) {
            query.setMaxResults(maxResults.intValue());
        }
        return query.getResultList();
    }

    public List<RecipientMessage> listByMessage(Message message) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(RecipientMessage.class);
        Root root = criteria.from(RecipientMessage.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(RecipientMessage_.message), (Object)message));
        return entityManager.createQuery(criteria).getResultList();
    }

    public Long countByRecipientAndReadAndRemoved(User recipient, Boolean read, Boolean removed) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Long.class);
        Root root = criteria.from(RecipientMessage.class);
        criteria.select((Selection)criteriaBuilder.count((Expression)root));
        criteria.where((Expression)criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)root.get(RecipientMessage_.recipient), (Object)recipient), criteriaBuilder.equal((Expression)root.get(RecipientMessage_.removed), (Object)removed), criteriaBuilder.equal((Expression)root.get(RecipientMessage_.read), (Object)read)}));
        return (Long)entityManager.createQuery(criteria).getSingleResult();
    }

    public RecipientMessage updateRead(RecipientMessage recipientMessage, Boolean read) {
        recipientMessage.setRead(read);
        this.getEntityManager().persist((Object)recipientMessage);
        return recipientMessage;
    }

    public RecipientMessage updateStarred(RecipientMessage recipientMessage, Boolean starred) {
        recipientMessage.setStarred(starred);
        this.getEntityManager().persist((Object)recipientMessage);
        return recipientMessage;
    }

    public RecipientMessage updateRemoved(RecipientMessage recipientMessage, Boolean removed) {
        recipientMessage.setRemoved(removed);
        this.getEntityManager().persist((Object)recipientMessage);
        return recipientMessage;
    }
}

