/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.materials;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.materials.VectorImage;
import fi.foyt.fni.persistence.model.materials.VectorImageRevision;
import fi.foyt.fni.persistence.model.materials.VectorImageRevision_;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class VectorImageRevisionDAO
extends GenericDAO<VectorImageRevision> {
    private static final long serialVersionUID = 1L;

    public VectorImageRevision create(VectorImage vectorImage, Long revision, Date created, Boolean compressed, Boolean completeRevision, byte[] data, String checksum, String sessionId) {
        VectorImageRevision vectorImageRevision = new VectorImageRevision();
        vectorImageRevision.setCreated(created);
        vectorImageRevision.setCompleteRevision(completeRevision);
        vectorImageRevision.setCompressed(compressed);
        vectorImageRevision.setCreated(created);
        vectorImageRevision.setData(data);
        vectorImageRevision.setVectorImage(vectorImage);
        vectorImageRevision.setRevision(revision);
        vectorImageRevision.setChecksum(checksum);
        vectorImageRevision.setSessionId(sessionId);
        return this.persist(vectorImageRevision);
    }

    public List<VectorImageRevision> listByVectorImage(VectorImage vectorImage) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(VectorImageRevision.class);
        Root root = criteria.from(VectorImageRevision.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(VectorImageRevision_.vectorImage), (Object)vectorImage));
        return entityManager.createQuery(criteria).getResultList();
    }

    public Long maxRevisionByVectorImage(VectorImage vectorImage) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Long.class);
        Root root = criteria.from(VectorImageRevision.class);
        criteria.select((Selection)criteriaBuilder.max((Expression)root.get(VectorImageRevision_.revision)));
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(VectorImageRevision_.vectorImage), (Object)vectorImage));
        return (Long)entityManager.createQuery(criteria).getSingleResult();
    }
}

