/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.materials;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.common.Language;
import fi.foyt.fni.persistence.model.materials.Folder;
import fi.foyt.fni.persistence.model.materials.MaterialPublicity;
import fi.foyt.fni.persistence.model.materials.VectorImage;
import fi.foyt.fni.persistence.model.materials.VectorImage_;
import fi.foyt.fni.persistence.model.users.User;
import java.util.Date;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class VectorImageDAO
extends GenericDAO<VectorImage> {
    private static final long serialVersionUID = 1L;

    public VectorImage create(User creator, Language language, Folder parentFolder, String urlName, String title, String data, MaterialPublicity publicity) {
        EntityManager entityManager = this.getEntityManager();
        Date now = new Date();
        VectorImage vectorImage = new VectorImage();
        vectorImage.setCreated(now);
        vectorImage.setCreator(creator);
        vectorImage.setData(data);
        vectorImage.setLanguage(language);
        vectorImage.setModified(now);
        vectorImage.setModifier(creator);
        vectorImage.setParentFolder(parentFolder);
        vectorImage.setTitle(title);
        vectorImage.setUrlName(urlName);
        vectorImage.setPublicity(publicity);
        entityManager.persist((Object)vectorImage);
        return vectorImage;
    }

    public Number lengthDataByCreator(User creator) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Number.class);
        Root root = criteria.from(VectorImage.class);
        criteria.select((Selection)criteriaBuilder.coalesce(criteriaBuilder.sum(criteriaBuilder.length((Expression)root.get(VectorImage_.data))), (Object)0));
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(VectorImage_.creator), (Object)creator));
        return (Number)entityManager.createQuery(criteria).getSingleResult();
    }

    public VectorImage updateData(VectorImage vectorImage, User modifier, String data) {
        EntityManager entityManager = this.getEntityManager();
        vectorImage.setData(data);
        vectorImage.setModified(new Date());
        vectorImage.setModifier(modifier);
        entityManager.persist((Object)vectorImage);
        return vectorImage;
    }

    public VectorImage updateLanguage(VectorImage vectorImage, User modifier, Language language) {
        EntityManager entityManager = this.getEntityManager();
        vectorImage.setLanguage(language);
        vectorImage.setModified(new Date());
        vectorImage.setModifier(modifier);
        entityManager.persist((Object)vectorImage);
        return vectorImage;
    }
}

