/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.materials;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.materials.Material;
import fi.foyt.fni.persistence.model.materials.MaterialRole;
import fi.foyt.fni.persistence.model.materials.UserMaterialRole;
import fi.foyt.fni.persistence.model.materials.UserMaterialRole_;
import fi.foyt.fni.persistence.model.users.User;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class UserMaterialRoleDAO
extends GenericDAO<UserMaterialRole> {
    private static final long serialVersionUID = 1L;

    public UserMaterialRole create(Material material, User user, MaterialRole role) {
        EntityManager entityManager = this.getEntityManager();
        UserMaterialRole userMaterialRole = new UserMaterialRole();
        userMaterialRole.setMaterial(material);
        userMaterialRole.setUser(user);
        userMaterialRole.setRole(role);
        entityManager.persist((Object)userMaterialRole);
        return userMaterialRole;
    }

    public UserMaterialRole findByMaterialAndUser(Material material, User user) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(UserMaterialRole.class);
        Root root = criteria.from(UserMaterialRole.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(UserMaterialRole_.material), (Object)material), (Expression)criteriaBuilder.equal((Expression)root.get(UserMaterialRole_.user), (Object)user)));
        return (UserMaterialRole)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }

    public List<UserMaterialRole> listByMaterial(Material material) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(UserMaterialRole.class);
        Root root = criteria.from(UserMaterialRole.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(UserMaterialRole_.material), (Object)material));
        return entityManager.createQuery(criteria).getResultList();
    }

    public List<UserMaterialRole> listByMaterialAndRole(Material material, MaterialRole role) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(UserMaterialRole.class);
        Root root = criteria.from(UserMaterialRole.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(UserMaterialRole_.material), (Object)material), (Expression)criteriaBuilder.equal((Expression)root.get(UserMaterialRole_.role), (Object)role)));
        return entityManager.createQuery(criteria).getResultList();
    }

    public UserMaterialRole updateRole(UserMaterialRole userMaterialRole, MaterialRole role) {
        userMaterialRole.setRole(role);
        this.getEntityManager().persist((Object)userMaterialRole);
        return userMaterialRole;
    }
}

