/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.materials;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.materials.Material;
import fi.foyt.fni.persistence.model.materials.StarredMaterial;
import fi.foyt.fni.persistence.model.materials.StarredMaterial_;
import fi.foyt.fni.persistence.model.users.User;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class StarredMaterialDAO
extends GenericDAO<StarredMaterial> {
    private static final long serialVersionUID = 1L;

    public StarredMaterial create(Material material, User user, Date created) {
        EntityManager entityManager = this.getEntityManager();
        StarredMaterial starredMaterial = new StarredMaterial();
        starredMaterial.setMaterial(material);
        starredMaterial.setUser(user);
        starredMaterial.setCreated(created);
        entityManager.persist((Object)starredMaterial);
        return starredMaterial;
    }

    public StarredMaterial findByMaterialAndUser(Material material, User user) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(StarredMaterial.class);
        Root root = criteria.from(StarredMaterial.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(StarredMaterial_.material), (Object)material), (Expression)criteriaBuilder.equal((Expression)root.get(StarredMaterial_.user), (Object)user)));
        return (StarredMaterial)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }

    public List<StarredMaterial> listByUserSortByCreated(User user) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(StarredMaterial.class);
        Root root = criteria.from(StarredMaterial.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(StarredMaterial_.user), (Object)user));
        criteria.orderBy(new Order[]{criteriaBuilder.desc((Expression)root.get(StarredMaterial_.created))});
        TypedQuery query = entityManager.createQuery(criteria);
        return query.getResultList();
    }

    public List<StarredMaterial> listByUserSortByCreated(User user, int firstResult, int maxResults) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(StarredMaterial.class);
        Root root = criteria.from(StarredMaterial.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(StarredMaterial_.user), (Object)user));
        criteria.orderBy(new Order[]{criteriaBuilder.desc((Expression)root.get(StarredMaterial_.created))});
        TypedQuery query = entityManager.createQuery(criteria);
        query.setFirstResult(firstResult);
        query.setMaxResults(maxResults);
        return query.getResultList();
    }

    public List<StarredMaterial> listByMaterial(Material material) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(StarredMaterial.class);
        Root root = criteria.from(StarredMaterial.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(StarredMaterial_.material), (Object)material));
        TypedQuery query = entityManager.createQuery(criteria);
        return query.getResultList();
    }

    public Long countByUser(User user) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Long.class);
        Root root = criteria.from(StarredMaterial.class);
        criteria.select((Selection)criteriaBuilder.count((Expression)root));
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(StarredMaterial_.user), (Object)user));
        return (Long)entityManager.createQuery(criteria).getSingleResult();
    }

    public StarredMaterial updateCreated(StarredMaterial starredMaterial, Date created) {
        starredMaterial.setCreated(created);
        this.getEntityManager().persist((Object)starredMaterial);
        return starredMaterial;
    }
}

