/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.materials;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.materials.Material;
import fi.foyt.fni.persistence.model.materials.MaterialView;
import fi.foyt.fni.persistence.model.materials.MaterialView_;
import fi.foyt.fni.persistence.model.users.User;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class MaterialViewDAO
extends GenericDAO<MaterialView> {
    private static final long serialVersionUID = 1L;

    public MaterialView create(Material material, User user, Integer count, Date viewed) {
        EntityManager entityManager = this.getEntityManager();
        MaterialView materialView = new MaterialView();
        materialView.setMaterial(material);
        materialView.setUser(user);
        materialView.setCount(count);
        materialView.setViewed(viewed);
        entityManager.persist((Object)materialView);
        return materialView;
    }

    public MaterialView findByMaterialAndUser(Material material, User user) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(MaterialView.class);
        Root root = criteria.from(MaterialView.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(MaterialView_.material), (Object)material), (Expression)criteriaBuilder.equal((Expression)root.get(MaterialView_.user), (Object)user)));
        return (MaterialView)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }

    public List<MaterialView> listByUserSortByViewed(User user, int firstResult, int maxResults) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(MaterialView.class);
        Root root = criteria.from(MaterialView.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(MaterialView_.user), (Object)user));
        criteria.orderBy(new Order[]{criteriaBuilder.desc((Expression)root.get(MaterialView_.viewed))});
        TypedQuery query = entityManager.createQuery(criteria);
        query.setFirstResult(firstResult);
        query.setMaxResults(maxResults);
        return query.getResultList();
    }

    public List<MaterialView> listByMaterial(Material material) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(MaterialView.class);
        Root root = criteria.from(MaterialView.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(MaterialView_.material), (Object)material));
        return entityManager.createQuery(criteria).getResultList();
    }

    public MaterialView updateCount(MaterialView materialView, Integer count) {
        EntityManager entityManager = this.getEntityManager();
        materialView.setCount(count);
        materialView = (MaterialView)entityManager.merge((Object)materialView);
        return materialView;
    }

    public MaterialView updateViewed(MaterialView materialView, Date viewed) {
        EntityManager entityManager = this.getEntityManager();
        materialView.setViewed(viewed);
        materialView = (MaterialView)entityManager.merge((Object)materialView);
        return materialView;
    }
}

