/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.materials;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.materials.ImageSize;
import fi.foyt.fni.persistence.model.materials.Material;
import fi.foyt.fni.persistence.model.materials.MaterialThumbnail;
import fi.foyt.fni.persistence.model.materials.MaterialThumbnail_;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class MaterialThumbnailDAO
extends GenericDAO<MaterialThumbnail> {
    private static final long serialVersionUID = 1L;

    public MaterialThumbnail create(Material material, ImageSize size, byte[] content, String contentType) {
        EntityManager entityManager = this.getEntityManager();
        MaterialThumbnail materialThumbnail = new MaterialThumbnail();
        materialThumbnail.setContent(content);
        materialThumbnail.setContentType(contentType);
        materialThumbnail.setMaterial(material);
        materialThumbnail.setSize(size.toString());
        entityManager.persist((Object)materialThumbnail);
        return materialThumbnail;
    }

    public MaterialThumbnail findByMaterialAndSize(Material material, ImageSize size) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(MaterialThumbnail.class);
        Root root = criteria.from(MaterialThumbnail.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(MaterialThumbnail_.material), (Object)material), (Expression)criteriaBuilder.equal((Expression)root.get(MaterialThumbnail_.size), (Object)size.toString())));
        return (MaterialThumbnail)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }

    public List<MaterialThumbnail> listByMaterial(Material material) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(MaterialThumbnail.class);
        Root root = criteria.from(MaterialThumbnail.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(MaterialThumbnail_.material), (Object)material));
        return entityManager.createQuery(criteria).getResultList();
    }
}

