/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.materials;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.common.Tag;
import fi.foyt.fni.persistence.model.materials.Material;
import fi.foyt.fni.persistence.model.materials.MaterialTag;
import fi.foyt.fni.persistence.model.materials.MaterialTag_;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class MaterialTagDAO
extends GenericDAO<MaterialTag> {
    private static final long serialVersionUID = 1L;

    public MaterialTag create(Material material, Tag tag) {
        EntityManager entityManager = this.getEntityManager();
        MaterialTag materialTag = new MaterialTag();
        materialTag.setMaterial(material);
        materialTag.setTag(tag);
        entityManager.persist((Object)materialTag);
        return materialTag;
    }

    public MaterialTag findByMaterialAndTag(Material material, Tag tag) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(MaterialTag.class);
        Root root = criteria.from(MaterialTag.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(MaterialTag_.material), (Object)material), (Expression)criteriaBuilder.equal((Expression)root.get(MaterialTag_.tag), (Object)tag)));
        return (MaterialTag)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }

    public List<MaterialTag> listByMaterial(Material material) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(MaterialTag.class);
        Root root = criteria.from(MaterialTag.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(MaterialTag_.material), (Object)material));
        return entityManager.createQuery(criteria).getResultList();
    }

    public List<MaterialTag> listByMaterialAndTagsNotIn(Material material, List<Tag> tags) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(MaterialTag.class);
        Root root = criteria.from(MaterialTag.class);
        criteria.select((Selection)root);
        criteria.where(new Predicate[]{criteriaBuilder.equal((Expression)root.get(MaterialTag_.material), (Object)material), criteriaBuilder.not((Expression)root.get(MaterialTag_.tag).in(tags))});
        return entityManager.createQuery(criteria).getResultList();
    }
}

