/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.materials;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.materials.Material;
import fi.foyt.fni.persistence.model.materials.MaterialSetting;
import fi.foyt.fni.persistence.model.materials.MaterialSettingKey;
import fi.foyt.fni.persistence.model.materials.MaterialSetting_;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class MaterialSettingDAO
extends GenericDAO<MaterialSetting> {
    private static final long serialVersionUID = 1L;

    public MaterialSetting create(Material material, MaterialSettingKey key, String value) {
        EntityManager entityManager = this.getEntityManager();
        MaterialSetting materialSetting = new MaterialSetting();
        materialSetting.setMaterial(material);
        materialSetting.setKey(key);
        materialSetting.setValue(value);
        entityManager.persist((Object)materialSetting);
        return materialSetting;
    }

    public MaterialSetting findByMaterialAndKey(Material material, MaterialSettingKey key) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(MaterialSetting.class);
        Root root = criteria.from(MaterialSetting.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(MaterialSetting_.material), (Object)material), (Expression)criteriaBuilder.equal((Expression)root.get(MaterialSetting_.key), (Object)key)));
        return (MaterialSetting)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }

    public List<MaterialSetting> listByMaterial(Material material) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(MaterialSetting.class);
        Root root = criteria.from(MaterialSetting.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(MaterialSetting_.material), (Object)material));
        return entityManager.createQuery(criteria).getResultList();
    }

    public MaterialSetting updateValue(MaterialSetting materialSetting, String value) {
        EntityManager entityManager = this.getEntityManager();
        materialSetting.setValue(value);
        entityManager.persist((Object)materialSetting);
        return materialSetting;
    }
}

