/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.materials;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.materials.Folder;
import fi.foyt.fni.persistence.model.materials.Material;
import fi.foyt.fni.persistence.model.materials.MaterialPublicity;
import fi.foyt.fni.persistence.model.materials.MaterialRole;
import fi.foyt.fni.persistence.model.materials.MaterialType;
import fi.foyt.fni.persistence.model.materials.Material_;
import fi.foyt.fni.persistence.model.materials.UserMaterialRole;
import fi.foyt.fni.persistence.model.materials.UserMaterialRole_;
import fi.foyt.fni.persistence.model.users.User;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class MaterialDAO
extends GenericDAO<Material> {
    private static final long serialVersionUID = 1L;

    public Material findByParentFolderAndUrlName(Folder parentFolder, String urlName) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Material.class);
        Root root = criteria.from(Material.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(Material_.parentFolder), (Object)parentFolder), (Expression)criteriaBuilder.equal((Expression)root.get(Material_.urlName), (Object)urlName)));
        return (Material)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }

    public Material findByRootFolderAndUrlName(User creator, String urlName) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Material.class);
        Root root = criteria.from(Material.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and(new Predicate[]{criteriaBuilder.isNull((Expression)root.get(Material_.parentFolder)), criteriaBuilder.equal((Expression)root.get(Material_.urlName), (Object)urlName), criteriaBuilder.equal((Expression)root.get(Material_.creator), (Object)creator)}));
        return (Material)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }

    public List<Material> listByParentFolder(Folder parentFolder) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Material.class);
        Root root = criteria.from(Material.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(Material_.parentFolder), (Object)parentFolder));
        return entityManager.createQuery(criteria).getResultList();
    }

    public List<Material> listByParentFolderAndTypes(Folder parentFolder, Collection<MaterialType> types) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Material.class);
        Root root = criteria.from(Material.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(Material_.parentFolder), (Object)parentFolder), (Expression)root.get(Material_.type).in(types)));
        return entityManager.createQuery(criteria).getResultList();
    }

    public List<Material> listByRootFolder() {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Material.class);
        Root root = criteria.from(Material.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.isNull((Expression)root.get(Material_.parentFolder)));
        return entityManager.createQuery(criteria).getResultList();
    }

    public List<Material> listByRootFolderAndCreator(User creator) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Material.class);
        Root root = criteria.from(Material.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.isNull((Expression)root.get(Material_.parentFolder)), (Expression)criteriaBuilder.equal((Expression)root.get(Material_.creator), (Object)creator)));
        return entityManager.createQuery(criteria).getResultList();
    }

    public List<Material> listByRootFolderAndTypesAndCreator(Collection<MaterialType> types, User creator) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Material.class);
        Root root = criteria.from(Material.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and(new Predicate[]{criteriaBuilder.isNull((Expression)root.get(Material_.parentFolder)), root.get(Material_.type).in(types), criteriaBuilder.equal((Expression)root.get(Material_.creator), (Object)creator)}));
        return entityManager.createQuery(criteria).getResultList();
    }

    public List<Material> listByRootFolderAndUserAndRoles(User user, Collection<MaterialRole> roles) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Material.class);
        Root root = criteria.from(UserMaterialRole.class);
        Join materialJoin = root.join(UserMaterialRole_.material);
        criteria.select((Selection)root.get(UserMaterialRole_.material)).distinct(true);
        criteria.where((Expression)criteriaBuilder.and(new Predicate[]{criteriaBuilder.isNull((Expression)materialJoin.get(Material_.parentFolder)), criteriaBuilder.equal((Expression)root.get(UserMaterialRole_.user), (Object)user), root.get(UserMaterialRole_.role).in(roles)}));
        return entityManager.createQuery(criteria).getResultList();
    }

    public List<Material> listByRootFolderAndUserAndTypesAndRoles(User user, Collection<MaterialType> types, Collection<MaterialRole> roles) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Material.class);
        Root root = criteria.from(UserMaterialRole.class);
        Join materialJoin = root.join(UserMaterialRole_.material);
        criteria.select((Selection)root.get(UserMaterialRole_.material)).distinct(true);
        criteria.where((Expression)criteriaBuilder.and(new Predicate[]{criteriaBuilder.isNull((Expression)materialJoin.get(Material_.parentFolder)), criteriaBuilder.equal((Expression)root.get(UserMaterialRole_.user), (Object)user), materialJoin.get(Material_.type).in(types), root.get(UserMaterialRole_.role).in(roles)}));
        return entityManager.createQuery(criteria).getResultList();
    }

    public List<Material> listByModifierExcludingTypesSortByModified(User modifier, Collection<MaterialType> types, int firstResult, int maxResults) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Material.class);
        Root root = criteria.from(Material.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(Material_.modifier), (Object)modifier), (Expression)criteriaBuilder.not((Expression)root.get(Material_.type).in(types))));
        criteria.orderBy(new Order[]{criteriaBuilder.desc((Expression)root.get(Material_.modified))});
        TypedQuery query = entityManager.createQuery(criteria);
        query.setFirstResult(firstResult);
        query.setMaxResults(maxResults);
        return query.getResultList();
    }

    public List<Material> listByModifiedAfter(Date modifiedAfter) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Material.class);
        Root root = criteria.from(Material.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.greaterThan((Expression)root.get(Material_.modified), (Comparable)modifiedAfter));
        return entityManager.createQuery(criteria).getResultList();
    }

    public Long countByCreator(User creator) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Long.class);
        Root root = criteria.from(Material.class);
        criteria.select((Selection)criteriaBuilder.count((Expression)root));
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(Material_.creator), (Object)creator));
        return (Long)entityManager.createQuery(criteria).getSingleResult();
    }

    public Material updatePublicity(Material material, MaterialPublicity publicity, User modifier) {
        material.setPublicity(publicity);
        material.setModified(new Date());
        material.setModifier(modifier);
        this.getEntityManager().persist((Object)material);
        return material;
    }

    public Material updateParentFolder(Material material, Folder parentFolder, User modifier) {
        material.setParentFolder(parentFolder);
        material.setModified(new Date());
        material.setModifier(modifier);
        this.getEntityManager().persist((Object)material);
        return material;
    }

    public Material updateUrlName(Material material, String urlName, User modifier) {
        EntityManager entityManager = this.getEntityManager();
        material.setUrlName(urlName);
        material.setModified(new Date());
        material.setModifier(modifier);
        entityManager.persist((Object)material);
        return material;
    }

    public Material updateTitle(Material material, String title, User modifier) {
        EntityManager entityManager = this.getEntityManager();
        material.setTitle(title);
        material.setModified(new Date());
        material.setModifier(modifier);
        entityManager.persist((Object)material);
        return material;
    }
}

