/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.materials;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.materials.Image;
import fi.foyt.fni.persistence.model.materials.ImageRevision;
import fi.foyt.fni.persistence.model.materials.ImageRevision_;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class ImageRevisionDAO
extends GenericDAO<ImageRevision> {
    private static final long serialVersionUID = 1L;

    public ImageRevision create(Image image, Long revision, Date created, Boolean compressed, Boolean completeRevision, byte[] data, String checksum, String sessionId) {
        ImageRevision imageRevision = new ImageRevision();
        imageRevision.setCreated(created);
        imageRevision.setCompleteRevision(completeRevision);
        imageRevision.setCompressed(compressed);
        imageRevision.setCreated(created);
        imageRevision.setData(data);
        imageRevision.setImage(image);
        imageRevision.setRevision(revision);
        imageRevision.setChecksum(checksum);
        imageRevision.setSessionId(sessionId);
        return this.persist(imageRevision);
    }

    public List<ImageRevision> listByImage(Image image) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(ImageRevision.class);
        Root root = criteria.from(ImageRevision.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(ImageRevision_.image), (Object)image));
        return entityManager.createQuery(criteria).getResultList();
    }

    public List<ImageRevision> listByImageAndRevisionGreaterThan(Image image, Long revision) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(ImageRevision.class);
        Root root = criteria.from(ImageRevision.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(ImageRevision_.image), (Object)image), (Expression)criteriaBuilder.greaterThan((Expression)root.get(ImageRevision_.revision), (Comparable)revision)));
        return entityManager.createQuery(criteria).getResultList();
    }

    public Long maxRevisionByImage(Image image) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Long.class);
        Root root = criteria.from(ImageRevision.class);
        criteria.select((Selection)criteriaBuilder.max((Expression)root.get(ImageRevision_.revision)));
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(ImageRevision_.image), (Object)image));
        return (Long)entityManager.createQuery(criteria).getSingleResult();
    }
}

