/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.materials;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.common.Language;
import fi.foyt.fni.persistence.model.materials.Folder;
import fi.foyt.fni.persistence.model.materials.Image;
import fi.foyt.fni.persistence.model.materials.Image_;
import fi.foyt.fni.persistence.model.materials.MaterialPublicity;
import fi.foyt.fni.persistence.model.users.User;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class ImageDAO
extends GenericDAO<Image> {
    private static final long serialVersionUID = 1L;

    public Image create(User creator, Date created, User modifier, Date modified, Language language, Folder parentFolder, String urlName, String title, byte[] data, String contentType, MaterialPublicity publicity) {
        EntityManager entityManager = this.getEntityManager();
        Image image = new Image();
        image.setCreated(created);
        image.setCreator(creator);
        image.setData(data);
        image.setModified(modified);
        image.setModifier(modifier);
        image.setTitle(title);
        image.setUrlName(urlName);
        image.setContentType(contentType);
        image.setPublicity(publicity);
        if (language != null) {
            image.setLanguage(language);
        }
        if (parentFolder != null) {
            image.setParentFolder(parentFolder);
        }
        entityManager.persist((Object)image);
        return image;
    }

    public List<Image> listByModifiedAfter(Date modifiedAfter) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Image.class);
        Root root = criteria.from(Image.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.greaterThan((Expression)root.get(Image_.modified), (Comparable)modifiedAfter));
        return entityManager.createQuery(criteria).getResultList();
    }

    public Image updateData(Image image, User modifier, byte[] data) {
        EntityManager entityManager = this.getEntityManager();
        image.setData(data);
        image.setModified(new Date());
        image.setModifier(modifier);
        image = (Image)entityManager.merge((Object)image);
        return image;
    }

    public Image updateContentType(Image image, User modifier, String contentType) {
        EntityManager entityManager = this.getEntityManager();
        image.setContentType(contentType);
        image.setModified(new Date());
        image.setModifier(modifier);
        image = (Image)entityManager.merge((Object)image);
        return image;
    }
}

