/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.materials;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.materials.IllusionEventFolder;
import fi.foyt.fni.persistence.model.materials.IllusionEventFolder_;
import fi.foyt.fni.persistence.model.materials.IllusionFolder;
import fi.foyt.fni.persistence.model.materials.MaterialPublicity;
import fi.foyt.fni.persistence.model.users.User;
import java.util.Date;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class IllusionEventFolderDAO
extends GenericDAO<IllusionEventFolder> {
    private static final long serialVersionUID = -4644199519384824575L;

    public IllusionEventFolder create(User creator, IllusionFolder parentFolder, String urlName, String title, MaterialPublicity publicity) {
        Date now = new Date();
        IllusionEventFolder illusionEventFolder = new IllusionEventFolder();
        illusionEventFolder.setCreated(now);
        illusionEventFolder.setCreator(creator);
        illusionEventFolder.setLanguage(null);
        illusionEventFolder.setModified(now);
        illusionEventFolder.setModifier(creator);
        illusionEventFolder.setParentFolder(parentFolder);
        illusionEventFolder.setPublicity(publicity);
        illusionEventFolder.setTitle(title);
        illusionEventFolder.setUrlName(urlName);
        return this.persist(illusionEventFolder);
    }

    public IllusionEventFolder findByParentFolderAndUrlName(IllusionFolder parentFolder, String urlName) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(IllusionEventFolder.class);
        Root root = criteria.from(IllusionEventFolder.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(IllusionEventFolder_.parentFolder), (Object)parentFolder), (Expression)criteriaBuilder.equal((Expression)root.get(IllusionEventFolder_.urlName), (Object)urlName)));
        return (IllusionEventFolder)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }
}

