/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.materials;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.common.Language;
import fi.foyt.fni.persistence.model.materials.Folder;
import fi.foyt.fni.persistence.model.materials.IllusionEventDocument;
import fi.foyt.fni.persistence.model.materials.IllusionEventDocumentType;
import fi.foyt.fni.persistence.model.materials.IllusionEventDocument_;
import fi.foyt.fni.persistence.model.materials.MaterialPublicity;
import fi.foyt.fni.persistence.model.users.User;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class IllusionEventDocumentDAO
extends GenericDAO<IllusionEventDocument> {
    private static final long serialVersionUID = -4644199519384824575L;

    public IllusionEventDocument create(User creator, IllusionEventDocumentType documentType, Language language, Folder parentFolder, String urlName, String title, String data, MaterialPublicity publicity, Integer indexNumber) {
        Date now = new Date();
        IllusionEventDocument illusionEventDocument = new IllusionEventDocument();
        illusionEventDocument.setData(data);
        illusionEventDocument.setCreated(now);
        illusionEventDocument.setCreator(creator);
        illusionEventDocument.setModified(now);
        illusionEventDocument.setModifier(creator);
        illusionEventDocument.setTitle(title);
        illusionEventDocument.setUrlName(urlName);
        illusionEventDocument.setPublicity(publicity);
        illusionEventDocument.setDocumentType(documentType);
        illusionEventDocument.setLanguage(language);
        illusionEventDocument.setParentFolder(parentFolder);
        illusionEventDocument.setIndexNumber(indexNumber);
        return this.persist(illusionEventDocument);
    }

    public IllusionEventDocument findByParentFolderAndDocumentType(Folder parentFolder, IllusionEventDocumentType documentType) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(IllusionEventDocument.class);
        Root root = criteria.from(IllusionEventDocument.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(IllusionEventDocument_.parentFolder), (Object)parentFolder), (Expression)criteriaBuilder.equal((Expression)root.get(IllusionEventDocument_.documentType), (Object)documentType)));
        return (IllusionEventDocument)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }

    public List<IllusionEventDocument> listByParentFolderAndDocumentType(Folder parentFolder, IllusionEventDocumentType documentType) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(IllusionEventDocument.class);
        Root root = criteria.from(IllusionEventDocument.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(IllusionEventDocument_.parentFolder), (Object)parentFolder), (Expression)criteriaBuilder.equal((Expression)root.get(IllusionEventDocument_.documentType), (Object)documentType)));
        return entityManager.createQuery(criteria).getResultList();
    }

    public Integer maxIndexNumberByParentFolder(Folder parentFolder) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Integer.class);
        Root root = criteria.from(IllusionEventDocument.class);
        criteria.select((Selection)criteriaBuilder.max((Expression)root.get(IllusionEventDocument_.indexNumber)));
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(IllusionEventDocument_.parentFolder), (Object)parentFolder));
        return (Integer)entityManager.createQuery(criteria).getSingleResult();
    }
}

