/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.materials;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.common.Language;
import fi.foyt.fni.persistence.model.materials.Folder;
import fi.foyt.fni.persistence.model.materials.GoogleDocument;
import fi.foyt.fni.persistence.model.materials.GoogleDocument_;
import fi.foyt.fni.persistence.model.materials.MaterialPublicity;
import fi.foyt.fni.persistence.model.users.User;
import java.util.Date;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class GoogleDocumentDAO
extends GenericDAO<GoogleDocument> {
    private static final long serialVersionUID = 1L;

    public GoogleDocument create(User creator, Language language, Folder parentFolder, String urlName, String title, String documentId, String mimeType, MaterialPublicity publicity) {
        EntityManager entityManager = this.getEntityManager();
        Date now = new Date();
        GoogleDocument googleDocument = new GoogleDocument();
        googleDocument.setDocumentId(documentId);
        googleDocument.setCreated(now);
        googleDocument.setCreator(creator);
        googleDocument.setModified(now);
        googleDocument.setModifier(creator);
        googleDocument.setTitle(title);
        googleDocument.setUrlName(urlName);
        googleDocument.setMimeType(mimeType);
        googleDocument.setPublicity(publicity);
        if (language != null) {
            googleDocument.setLanguage(language);
        }
        if (parentFolder != null) {
            googleDocument.setParentFolder(parentFolder);
        }
        entityManager.persist((Object)googleDocument);
        return googleDocument;
    }

    public GoogleDocument findByCreatorAndDocumentId(User creator, String documentId) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(GoogleDocument.class);
        Root root = criteria.from(GoogleDocument.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(GoogleDocument_.creator), (Object)creator), (Expression)criteriaBuilder.equal((Expression)root.get(GoogleDocument_.documentId), (Object)documentId)));
        return (GoogleDocument)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }
}

