/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.materials;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.common.Language;
import fi.foyt.fni.persistence.model.materials.Folder;
import fi.foyt.fni.persistence.model.materials.Folder_;
import fi.foyt.fni.persistence.model.materials.MaterialPublicity;
import fi.foyt.fni.persistence.model.users.User;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class FolderDAO
extends GenericDAO<Folder> {
    private static final long serialVersionUID = 1L;

    public Folder create(User creator, Date created, User modifier, Date modified, Language language, Folder parentFolder, String urlName, String title, MaterialPublicity publicity) {
        EntityManager entityManager = this.getEntityManager();
        Folder folder = new Folder();
        folder.setCreated(created);
        folder.setCreator(creator);
        folder.setModified(modified);
        folder.setModifier(modifier);
        folder.setTitle(title);
        folder.setUrlName(urlName);
        folder.setPublicity(publicity);
        if (language != null) {
            folder.setLanguage(language);
        }
        if (parentFolder != null) {
            folder.setParentFolder(parentFolder);
        }
        entityManager.persist((Object)folder);
        return folder;
    }

    public List<Folder> listByParentFolder(Folder parentFolder) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Folder.class);
        Root root = criteria.from(Folder.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(Folder_.parentFolder), (Object)parentFolder));
        return entityManager.createQuery(criteria).getResultList();
    }

    public List<Folder> listByModifiedAfter(Date modifiedAfter) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Folder.class);
        Root root = criteria.from(Folder.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.greaterThan((Expression)root.get(Folder_.modified), (Comparable)modifiedAfter));
        return entityManager.createQuery(criteria).getResultList();
    }

    public Folder updateCreated(Folder folder, Date created) {
        EntityManager entityManager = this.getEntityManager();
        folder.setCreated(created);
        entityManager.persist((Object)folder);
        return folder;
    }

    public Folder updateModifier(Folder folder, User modifier) {
        EntityManager entityManager = this.getEntityManager();
        folder.setModifier(modifier);
        entityManager.persist((Object)folder);
        return folder;
    }

    public Folder updateModified(Folder folder, Date modified) {
        EntityManager entityManager = this.getEntityManager();
        folder.setModified(modified);
        entityManager.persist((Object)folder);
        return folder;
    }
}

