/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.materials;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.materials.DropboxRootFolder;
import fi.foyt.fni.persistence.model.materials.DropboxRootFolder_;
import fi.foyt.fni.persistence.model.materials.Folder;
import fi.foyt.fni.persistence.model.materials.MaterialPublicity;
import fi.foyt.fni.persistence.model.users.User;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class DropboxRootFolderDAO
extends GenericDAO<DropboxRootFolder> {
    private static final long serialVersionUID = 1L;

    public DropboxRootFolder create(User creator, Date created, User modifier, Date modified, Folder parentFolder, String urlName, String title, MaterialPublicity publicity, String deltaCursor, Date lastSynchronized) {
        EntityManager entityManager = this.getEntityManager();
        DropboxRootFolder dropboxRootFolder = new DropboxRootFolder();
        dropboxRootFolder.setCreated(created);
        dropboxRootFolder.setCreator(creator);
        dropboxRootFolder.setModified(modified);
        dropboxRootFolder.setModifier(modifier);
        dropboxRootFolder.setTitle(title);
        dropboxRootFolder.setUrlName(urlName);
        dropboxRootFolder.setPublicity(publicity);
        dropboxRootFolder.setLanguage(null);
        dropboxRootFolder.setParentFolder(parentFolder);
        dropboxRootFolder.setDeltaCursor(deltaCursor);
        dropboxRootFolder.setLastSynchronized(lastSynchronized);
        entityManager.persist((Object)dropboxRootFolder);
        return dropboxRootFolder;
    }

    public DropboxRootFolder findByUser(User user) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(DropboxRootFolder.class);
        Root root = criteria.from(DropboxRootFolder.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(DropboxRootFolder_.creator), (Object)user));
        return (DropboxRootFolder)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }

    public List<DropboxRootFolder> listAllSortByAscLastSynchronized(Integer firstResult, Integer maxResults) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(DropboxRootFolder.class);
        Root root = criteria.from(DropboxRootFolder.class);
        criteria.select((Selection)root);
        criteria.orderBy(new Order[]{criteriaBuilder.asc((Expression)root.get(DropboxRootFolder_.lastSynchronized))});
        TypedQuery query = entityManager.createQuery(criteria);
        query.setFirstResult(firstResult.intValue());
        query.setMaxResults(maxResults.intValue());
        return query.getResultList();
    }

    public DropboxRootFolder updateDeltaCursor(DropboxRootFolder dropboxRootFolder, String deltaCursor, User modifier) {
        EntityManager entityManager = this.getEntityManager();
        dropboxRootFolder.setDeltaCursor(deltaCursor);
        dropboxRootFolder.setModifier(modifier);
        entityManager.persist((Object)dropboxRootFolder);
        return dropboxRootFolder;
    }

    public DropboxRootFolder updateLastSynchronized(DropboxRootFolder dropboxRootFolder, Date lastSynchronized, User modifier) {
        EntityManager entityManager = this.getEntityManager();
        dropboxRootFolder.setLastSynchronized(lastSynchronized);
        dropboxRootFolder.setModifier(modifier);
        entityManager.persist((Object)dropboxRootFolder);
        return dropboxRootFolder;
    }
}

