/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.materials;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.materials.DropboxFolder;
import fi.foyt.fni.persistence.model.materials.DropboxFolder_;
import fi.foyt.fni.persistence.model.materials.Folder;
import fi.foyt.fni.persistence.model.materials.MaterialPublicity;
import fi.foyt.fni.persistence.model.users.User;
import java.util.Date;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class DropboxFolderDAO
extends GenericDAO<DropboxFolder> {
    private static final long serialVersionUID = 1L;

    public DropboxFolder create(User creator, Date created, User modifier, Date modified, Folder parentFolder, String urlName, String title, MaterialPublicity publicity, String dropboxPath) {
        EntityManager entityManager = this.getEntityManager();
        DropboxFolder dropboxFolder = new DropboxFolder();
        dropboxFolder.setCreated(created);
        dropboxFolder.setCreator(creator);
        dropboxFolder.setModified(modified);
        dropboxFolder.setModifier(modifier);
        dropboxFolder.setTitle(title);
        dropboxFolder.setUrlName(urlName);
        dropboxFolder.setPublicity(publicity);
        dropboxFolder.setLanguage(null);
        dropboxFolder.setParentFolder(parentFolder);
        dropboxFolder.setDropboxPath(dropboxPath);
        entityManager.persist((Object)dropboxFolder);
        return dropboxFolder;
    }

    public DropboxFolder findByCreatorAndDropboxPath(User creator, String dropboxPath) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(DropboxFolder.class);
        Root root = criteria.from(DropboxFolder.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(DropboxFolder_.dropboxPath), (Object)dropboxPath), (Expression)criteriaBuilder.equal((Expression)root.get(DropboxFolder_.creator), (Object)creator)));
        return (DropboxFolder)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }
}

