/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.materials;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.common.Language;
import fi.foyt.fni.persistence.model.materials.DropboxFile;
import fi.foyt.fni.persistence.model.materials.DropboxFile_;
import fi.foyt.fni.persistence.model.materials.Folder;
import fi.foyt.fni.persistence.model.materials.MaterialPublicity;
import fi.foyt.fni.persistence.model.users.User;
import java.util.Date;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class DropboxFileDAO
extends GenericDAO<DropboxFile> {
    private static final long serialVersionUID = 1L;

    public DropboxFile create(User creator, Language language, Folder parentFolder, String urlName, String title, MaterialPublicity publicity, String dropboxPath, String mimeType) {
        EntityManager entityManager = this.getEntityManager();
        Date now = new Date();
        DropboxFile dropboxFile = new DropboxFile();
        dropboxFile.setCreated(now);
        dropboxFile.setCreator(creator);
        dropboxFile.setModified(now);
        dropboxFile.setModifier(creator);
        dropboxFile.setTitle(title);
        dropboxFile.setUrlName(urlName);
        dropboxFile.setPublicity(publicity);
        dropboxFile.setLanguage(language);
        dropboxFile.setParentFolder(parentFolder);
        dropboxFile.setDropboxPath(dropboxPath);
        dropboxFile.setMimeType(mimeType);
        entityManager.persist((Object)dropboxFile);
        return dropboxFile;
    }

    public DropboxFile findByDropboxPath(String dropboxPath) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(DropboxFile.class);
        Root root = criteria.from(DropboxFile.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(DropboxFile_.dropboxPath), (Object)dropboxPath));
        return (DropboxFile)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }
}

