/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.materials;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.materials.Document;
import fi.foyt.fni.persistence.model.materials.DocumentRevision;
import fi.foyt.fni.persistence.model.materials.DocumentRevision_;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class DocumentRevisionDAO
extends GenericDAO<DocumentRevision> {
    private static final long serialVersionUID = 1L;

    public DocumentRevision create(Document document, Long revision, Date created, Boolean compressed, Boolean completeRevision, byte[] data, String checksum, String sessionId) {
        DocumentRevision documentRevision = new DocumentRevision();
        documentRevision.setCreated(created);
        documentRevision.setCompleteRevision(completeRevision);
        documentRevision.setCompressed(compressed);
        documentRevision.setCreated(created);
        documentRevision.setData(data);
        documentRevision.setDocument(document);
        documentRevision.setRevision(revision);
        documentRevision.setChecksum(checksum);
        documentRevision.setSessionId(sessionId);
        return this.persist(documentRevision);
    }

    public List<DocumentRevision> listByDocument(Document document) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(DocumentRevision.class);
        Root root = criteria.from(DocumentRevision.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(DocumentRevision_.document), (Object)document));
        return entityManager.createQuery(criteria).getResultList();
    }

    public List<DocumentRevision> listByDocumentAndRevisionGreaterThan(Document document, Long revision) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(DocumentRevision.class);
        Root root = criteria.from(DocumentRevision.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(DocumentRevision_.document), (Object)document), (Expression)criteriaBuilder.greaterThan((Expression)root.get(DocumentRevision_.revision), (Comparable)revision)));
        return entityManager.createQuery(criteria).getResultList();
    }

    public Long maxRevisionByDocument(Document document) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Long.class);
        Root root = criteria.from(DocumentRevision.class);
        criteria.select((Selection)criteriaBuilder.max((Expression)root.get(DocumentRevision_.revision)));
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(DocumentRevision_.document), (Object)document));
        return (Long)entityManager.createQuery(criteria).getSingleResult();
    }
}

