/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.materials;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.materials.CoOpsSession;
import fi.foyt.fni.persistence.model.materials.CoOpsSessionType;
import fi.foyt.fni.persistence.model.materials.CoOpsSession_;
import fi.foyt.fni.persistence.model.materials.Material;
import fi.foyt.fni.persistence.model.users.User;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class CoOpsSessionDAO
extends GenericDAO<CoOpsSession> {
    private static final long serialVersionUID = -5793299154748976020L;

    public CoOpsSession create(Material material, User user, String sessionId, CoOpsSessionType type, Boolean closed, String algorithm, Long joinRevision, Date accessed) {
        CoOpsSession coOpsSession = new CoOpsSession();
        coOpsSession.setAlgorithm(algorithm);
        coOpsSession.setJoinRevision(joinRevision);
        coOpsSession.setMaterial(material);
        coOpsSession.setUser(user);
        coOpsSession.setSessionId(sessionId);
        coOpsSession.setType(type);
        coOpsSession.setClosed(closed);
        coOpsSession.setAccessed(accessed);
        return this.persist(coOpsSession);
    }

    public CoOpsSession findBySessionId(String sessionId) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(CoOpsSession.class);
        Root root = criteria.from(CoOpsSession.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(CoOpsSession_.sessionId), (Object)sessionId));
        return (CoOpsSession)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }

    public List<CoOpsSession> listByClosed(Boolean closed) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(CoOpsSession.class);
        Root root = criteria.from(CoOpsSession.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(CoOpsSession_.closed), (Object)closed));
        return entityManager.createQuery(criteria).getResultList();
    }

    public List<CoOpsSession> listByUserAndClosed(User user, Boolean closed) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(CoOpsSession.class);
        Root root = criteria.from(CoOpsSession.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(CoOpsSession_.closed), (Object)closed), (Expression)criteriaBuilder.equal((Expression)root.get(CoOpsSession_.user), (Object)user)));
        return entityManager.createQuery(criteria).getResultList();
    }

    public List<CoOpsSession> listByMaterialAndClosed(Material material, Boolean closed) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(CoOpsSession.class);
        Root root = criteria.from(CoOpsSession.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(CoOpsSession_.closed), (Object)closed), (Expression)criteriaBuilder.equal((Expression)root.get(CoOpsSession_.material), (Object)material)));
        return entityManager.createQuery(criteria).getResultList();
    }

    public List<CoOpsSession> listByAccessedBeforeAndTypeAndClosed(Date accessed, CoOpsSessionType type, Boolean closed) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(CoOpsSession.class);
        Root root = criteria.from(CoOpsSession.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)root.get(CoOpsSession_.closed), (Object)closed), criteriaBuilder.equal((Expression)root.get(CoOpsSession_.type), (Object)type), criteriaBuilder.lessThan((Expression)root.get(CoOpsSession_.accessed), (Comparable)accessed)}));
        return entityManager.createQuery(criteria).getResultList();
    }

    public CoOpsSession updateClosed(CoOpsSession coOpsSession, Boolean closed) {
        coOpsSession.setClosed(closed);
        return this.persist(coOpsSession);
    }

    public CoOpsSession updateType(CoOpsSession coOpsSession, CoOpsSessionType type) {
        coOpsSession.setType(type);
        return this.persist(coOpsSession);
    }
}

