/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.materials;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.materials.CharacterSheet;
import fi.foyt.fni.persistence.model.materials.CharacterSheetEntry;
import fi.foyt.fni.persistence.model.materials.CharacterSheetEntryType;
import fi.foyt.fni.persistence.model.materials.CharacterSheetEntry_;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class CharacterSheetEntryDAO
extends GenericDAO<CharacterSheetEntry> {
    private static final long serialVersionUID = 1L;

    public CharacterSheetEntry create(CharacterSheet sheet, String name, CharacterSheetEntryType type) {
        CharacterSheetEntry characterSheetEntry = new CharacterSheetEntry();
        characterSheetEntry.setName(name);
        characterSheetEntry.setSheet(sheet);
        characterSheetEntry.setType(type);
        return this.persist(characterSheetEntry);
    }

    public List<CharacterSheetEntry> listBySheet(CharacterSheet sheet) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(CharacterSheetEntry.class);
        Root root = criteria.from(CharacterSheetEntry.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(CharacterSheetEntry_.sheet), (Object)sheet));
        return entityManager.createQuery(criteria).getResultList();
    }

    public CharacterSheetEntry findBySheetAndName(CharacterSheet sheet, String name) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(CharacterSheetEntry.class);
        Root root = criteria.from(CharacterSheetEntry.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(CharacterSheetEntry_.sheet), (Object)sheet), (Expression)criteriaBuilder.equal((Expression)root.get(CharacterSheetEntry_.name), (Object)name)));
        return (CharacterSheetEntry)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }

    public CharacterSheetEntry updateType(CharacterSheetEntry entry, CharacterSheetEntryType type) {
        entry.setType(type);
        return this.persist(entry);
    }
}

